/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Dimension;
import java.awt.RenderingHints;
import java.util.concurrent.Callable;
import javax.imageio.ImageReadParam;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleLoadingException;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.operation.MathTransform2D;

public class GranuleLoader
implements Callable<GranuleDescriptor.GranuleLoadingResult> {
    final ReferencedEnvelope cropBBox;
    final MathTransform2D mosaicWorldToGrid;
    final GranuleDescriptor granuleDescriptor;
    final ImageReadParam readParameters;
    final int imageIndex;
    final Hints hints;
    RasterLayerRequest request;

    public GranuleLoader(ImageReadParam readParameters, int imageIndex, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, GranuleDescriptor granuleDescriptor, RasterLayerRequest request, Hints hints) {
        this.readParameters = ImageUtilities.cloneImageReadParam((ImageReadParam)readParameters);
        this.imageIndex = imageIndex;
        this.cropBBox = cropBBox;
        this.mosaicWorldToGrid = mosaicWorldToGrid;
        this.granuleDescriptor = granuleDescriptor;
        this.request = request;
        this.hints = new Hints((RenderingHints)hints);
        if (request.getTileDimensions() != null) {
            Dimension tileDimension = request.getTileDimensions();
            if (hints != null && hints.containsKey((Object)JAI.KEY_IMAGE_LAYOUT)) {
                Object layout = this.hints.get((Object)JAI.KEY_IMAGE_LAYOUT);
                if (layout != null && layout instanceof ImageLayout) {
                    ImageLayout imageLayout = (ImageLayout)layout;
                    imageLayout.setTileHeight(tileDimension.height);
                    imageLayout.setTileWidth(tileDimension.width);
                }
            } else {
                ImageLayout layout = new ImageLayout();
                layout.setTileWidth(tileDimension.width).setTileHeight(tileDimension.height);
                this.hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
        }
    }

    public BoundingBox getCropBBox() {
        return this.cropBBox;
    }

    public MathTransform2D getMosaicWorldToGrid() {
        return this.mosaicWorldToGrid;
    }

    public GranuleDescriptor getGranule() {
        return this.granuleDescriptor;
    }

    public ImageReadParam getReadParameters() {
        return this.readParameters;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    @Override
    public GranuleDescriptor.GranuleLoadingResult call() throws Exception {
        try {
            return this.granuleDescriptor.loadRaster(this.readParameters, this.imageIndex, this.cropBBox, this.mosaicWorldToGrid, this.request, this.hints);
        }
        catch (Exception e) {
            throw new GranuleLoadingException("Failed to load granule " + this.granuleDescriptor.getGranuleUrl(), e);
        }
    }
}

