/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.geotools.data.h2.H2Dialect;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class H2FilterToSQL
extends FilterToSQL {
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        caps.addType(NativeFilter.class);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("ST_GeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        return this.visitBinarySpatialOperator(filter, (Expression)property, (Expression)geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        return this.visitBinarySpatialOperator(filter, e1, e2, false, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, boolean swapped, Object extraData) {
        double distance = 0.0;
        try {
            String spatialIndex;
            Expression geometry;
            if (filter instanceof DistanceBufferOperator) {
                this.out.write("ST_Distance(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(", ");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator");
                }
                distance = this.getDistanceInNativeUnits((DistanceBufferOperator)filter);
                this.out.write(Double.toString(distance));
            } else if (filter instanceof BBOX) {
                this.out.write("ST_Intersects(");
                e1.accept((ExpressionVisitor)this, extraData);
                this.out.write(",");
                e2.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
            } else {
                if (filter instanceof Contains) {
                    this.out.write("ST_Contains(");
                } else if (filter instanceof Crosses) {
                    this.out.write("ST_Crosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write("ST_Disjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write("ST_Equals(");
                } else if (filter instanceof Intersects) {
                    this.out.write("ST_Intersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write("ST_Overlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write("ST_Touches(");
                } else if (filter instanceof Within) {
                    this.out.write("ST_Within(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    e2.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e1.accept((ExpressionVisitor)this, extraData);
                } else {
                    e1.accept((ExpressionVisitor)this, extraData);
                    this.out.write(", ");
                    e2.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(")");
            }
            Object object = e1 instanceof Literal ? e1 : (geometry = e2 instanceof Literal ? e2 : null);
            if (geometry != null && !(filter instanceof Disjoint) && !(filter instanceof Beyond) && (spatialIndex = (String)this.currentGeometry.getUserData().get(H2Dialect.H2_SPATIAL_INDEX)) != null && this.primaryKey.getColumns().size() == 1 && Number.class.isAssignableFrom(((PrimaryKeyColumn)this.primaryKey.getColumns().get(0)).getType())) {
                Envelope e = (Envelope)geometry.evaluate(null, Envelope.class);
                if (filter instanceof DWithin) {
                    e.expandBy(distance);
                }
                this.out.write(" AND ");
                this.out.write("\"" + ((PrimaryKeyColumn)this.primaryKey.getColumns().get(0)).getName() + "\" ");
                this.out.write("IN (");
                this.out.write("SELECT CAST(HATBOX_JOIN_ID AS INT)");
                this.out.write(" FROM HATBOX_MBR_INTERSECTS_ENV(");
                if (this.databaseSchema != null) {
                    this.out.write("'" + this.databaseSchema + "', ");
                } else {
                    this.out.write("'PUBLIC', ");
                }
                this.out.write("'" + this.featureType.getTypeName() + "', ");
                this.out.write(e.getMinX() + ", " + e.getMaxX() + ", " + e.getMinY() + ", " + e.getMaxY());
                this.out.write(")");
                this.out.write(")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }

    protected void writeLiteral(Object literal) throws IOException {
        if (literal instanceof java.util.Date) {
            this.out.write("PARSEDATETIME(");
            if (literal instanceof Date) {
                SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
                this.out.write("'" + DATE_FORMAT.format(literal) + "', 'yyyy-MM-dd'");
            } else {
                SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                this.out.write("'" + DATETIME_FORMAT.format(literal) + "', 'yyyy-MM-dd HH:mm:ss.SSSZ'");
            }
            this.out.write(")");
        } else {
            super.writeLiteral(literal);
        }
    }
}

