/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity.time;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.quantity.time.TimeQuantities;
import tec.uom.se.unit.Units;

public final class TimeUnitQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = -5840251813363744230L;
    private final TimeUnit timeUnit;
    private final Integer value;

    TimeUnitQuantity(TimeUnit timeUnit, Integer value) {
        super(TimeUnitQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public static TimeUnitQuantity of(TimeUnit timeUnit, Integer number) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TimeUnitQuantity of(Quantity<Time> quantity) {
        Quantity<Time> seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().intValue());
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TimeUnitQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TimeUnitQuantity to(TimeUnit timeUnit) {
        Quantity<Time> time = this.toQuantity().to(TimeUnitQuantity.toUnit(timeUnit));
        return new TimeUnitQuantity(timeUnit, time.getValue().intValue());
    }

    private static Unit<Time> toUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECONDS: {
                return TimeQuantities.MICROSECOND;
            }
            case MILLISECONDS: {
                return TimeQuantities.MILLISECOND;
            }
            case NANOSECONDS: {
                return TimeQuantities.NANOSECOND;
            }
            case SECONDS: {
                return Units.SECOND;
            }
            case MINUTES: {
                return Units.MINUTE;
            }
            case HOURS: {
                return Units.HOUR;
            }
            case DAYS: {
                return Units.DAY;
            }
        }
        throw new IllegalStateException("In TimeUnitQuantity just supports DAYS, HOURS, MICROSECONDS, MILLISECONDS, MINUTES, NANOSECONDS, SECONDS ");
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.timeUnit, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TimeUnitQuantity.class.isInstance(obj)) {
            TimeUnitQuantity other = (TimeUnitQuantity)TimeUnitQuantity.class.cast(obj);
            return Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Time unit:" + (Object)((Object)this.timeUnit) + " value: " + this.value;
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value + that.getValue().intValue()), this.timeUnit);
        }
        Quantity<Time> converted = that.to(this.getUnit());
        return TimeQuantities.getQuantity((Integer)(this.value + converted.getValue().intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value - that.getValue().intValue()), this.timeUnit);
        }
        Quantity<Time> converted = that.to(this.getUnit());
        return TimeQuantities.getQuantity((Integer)(this.value - converted.getValue().intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
        Unit<?> divUnit = this.getUnit().divide(that.getUnit());
        try {
            UnitConverter conv = this.getUnit().getConverterToAny(divUnit);
            return TimeQuantities.getQuantity((Integer)(this.value / conv.convert(that.getValue()).intValue()), this.timeUnit);
        }
        catch (UnconvertibleException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
        catch (IncommensurableException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return TimeQuantities.getQuantity((Integer)(this.value / that.intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> multiplier) {
        if (this.getUnit().equals(multiplier.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
        Unit<?> mulUnit = this.getUnit().multiply(multiplier.getUnit());
        try {
            UnitConverter conv = this.getUnit().getConverterToAny(mulUnit);
            return TimeQuantities.getQuantity((Integer)(this.value * conv.convert(multiplier.getValue()).intValue()), this.timeUnit);
        }
        catch (UnconvertibleException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
        catch (IncommensurableException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
    }

    @Override
    public ComparableQuantity<Time> multiply(Number multiplier) {
        return TimeQuantities.getQuantity((Integer)(this.value * multiplier.intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<?> inverse() {
        return TimeQuantities.getQuantity((Integer)(1 / this.value), this.timeUnit);
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public BigDecimal decimalValue(Unit<Time> unit, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.value.doubleValue());
    }

    @Override
    public double doubleValue(Unit<Time> unit) throws ArithmeticException {
        return this.value.doubleValue();
    }
}

