/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.MapEntry;
import org.geotools.util.WeakCollectionCleaner;
import org.geotools.util.logging.Logging;

public class SoftValueHashMap<K, V>
extends AbstractMap<K, V> {
    static final Logger LOGGER = Logging.getLogger(SoftValueHashMap.class);
    private static final int DEFAULT_HARD_REFERENCE_COUNT = 20;
    private final Map<K, Object> hash = new ConcurrentHashMap<K, Object>();
    private final Queue<K> hardCache = new ConcurrentLinkedQueue<K>();
    private final int hardReferencesCount;
    private transient Set<Map.Entry<K, V>> entries;
    protected ValueCleaner cleaner;

    public SoftValueHashMap() {
        this.cleaner = null;
        this.hardReferencesCount = 20;
    }

    public SoftValueHashMap(int hardReferencesCount) {
        this.cleaner = null;
        this.hardReferencesCount = hardReferencesCount;
    }

    public SoftValueHashMap(int hardReferencesCount, ValueCleaner cleaner) {
        this.cleaner = cleaner;
        this.hardReferencesCount = hardReferencesCount;
    }

    public int getHardReferencesCount() {
        return this.hardReferencesCount;
    }

    private static void ensureNotNull(Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Errors.format(143, "value"));
        }
    }

    final boolean isValid() {
        int count = 0;
        int size = 0;
        for (Map.Entry<K, Object> entry : this.hash.entrySet()) {
            if (entry.getValue() instanceof Reference) {
                ++count;
            } else assert (this.hardCache.contains(entry.getKey()));
            ++size;
        }
        assert (size == this.hash.size());
        assert (this.hardCache.size() == Math.min(size, this.hardReferencesCount));
        return count == Math.max(size - this.hardReferencesCount, 0);
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(SoftValueHashMap.replaceNull(key));
    }

    @Override
    public boolean containsValue(Object value) {
        SoftValueHashMap.ensureNotNull(value);
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Object value = this.hash.get(SoftValueHashMap.replaceNull(key));
        if (value instanceof Reference) {
            if ((value = ((Reference)value).getAndClear()) != null) {
                Object k = key;
                this.hash.put(k, value);
                this.retainStrongly(SoftValueHashMap.replaceNull(k));
            } else {
                this.hash.remove(SoftValueHashMap.replaceNull(key));
            }
        }
        Object v = value;
        return (V)v;
    }

    private void retainStrongly(K key) {
        this.hardCache.add(SoftValueHashMap.replaceNull(key));
        if (this.hardCache.size() > this.hardReferencesCount) {
            K toRemove = this.hardCache.poll();
            Object value = this.hash.get(SoftValueHashMap.replaceNull(toRemove));
            Object v = value;
            if (v instanceof Reference) {
                this.hash.put(SoftValueHashMap.replaceNull(toRemove), v);
            } else {
                this.hash.put(SoftValueHashMap.replaceNull(toRemove), new Reference<Object, Object>(this.hash, SoftValueHashMap.replaceNull(toRemove), v, this.cleaner));
            }
        }
    }

    @Override
    public V put(K key, V value) {
        SoftValueHashMap.ensureNotNull(value);
        Object oldValue = this.hash.put(SoftValueHashMap.replaceNull(key), value);
        if (oldValue instanceof Reference) {
            oldValue = ((Reference)oldValue).getAndClear();
        } else if (oldValue != null) {
            this.hardCache.remove(SoftValueHashMap.replaceNull(key));
        }
        this.retainStrongly(SoftValueHashMap.replaceNull(key));
        Object v = oldValue;
        return (V)v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    @Override
    public V remove(Object key) {
        Object oldValue = this.hash.remove(SoftValueHashMap.replaceNull(key));
        if (oldValue instanceof Reference) {
            oldValue = ((Reference)oldValue).getAndClear();
        } else if (oldValue != null) {
            this.hardCache.remove(SoftValueHashMap.replaceNull(key));
        }
        Object v = oldValue;
        return (V)v;
    }

    @Override
    public void clear() {
        for (Object value : this.hash.values()) {
            if (!(value instanceof Reference)) continue;
            ((Reference)value).getAndClear();
        }
        this.hash.clear();
        this.hardCache.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new Entries();
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private static Object replaceNull(Object o) {
        return o == null ? Null.PLACEHOLDER : o;
    }

    private static Object resolveNull(Object value) {
        return value == Null.PLACEHOLDER ? null : value;
    }

    private static enum Null {
        PLACEHOLDER;

    }

    public static interface ValueCleaner {
        public void clean(Object var1, Object var2);
    }

    private static final class Reference<K, V>
    extends SoftReference<V> {
        private final Map<K, Object> hash;
        private final K key;
        private ValueCleaner cleaner;

        Reference(Map<K, Object> hash, K key, V value, ValueCleaner cleaner) {
            super(value, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.hash = hash;
            this.key = key;
            this.cleaner = cleaner;
        }

        final Object getAndClear() {
            Object value = this.get();
            super.clear();
            return value;
        }

        @Override
        public void clear() {
            Object value;
            if (this.cleaner != null && (value = this.get()) != null) {
                try {
                    this.cleaner.clean(SoftValueHashMap.replaceNull(this.key), value);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "Exception occurred while cleaning soft referenced object", t);
                }
            }
            super.clear();
            Object old = this.hash.remove(SoftValueHashMap.replaceNull(this.key));
            if (old != this && old != null) {
                this.hash.put(SoftValueHashMap.replaceNull(this.key), old);
            }
        }
    }

    private static final class Iter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Object>> iterator;
        private transient Map.Entry<K, V> entry;

        Iter(Map<K, Object> hash) {
            this.iterator = hash.entrySet().iterator();
        }

        private boolean findNext() {
            while (this.iterator.hasNext()) {
                Map.Entry<K, Object> candidate = this.iterator.next();
                Object value = candidate.getValue();
                if (value instanceof Reference) {
                    value = ((Reference)value).get();
                    this.entry = new MapEntry<Object, Object>(SoftValueHashMap.resolveNull(candidate.getKey()), value);
                    return true;
                }
                if (value == null) continue;
                this.entry = new MapEntry<Object, Object>(SoftValueHashMap.resolveNull(candidate.getKey()), value);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.entry != null || this.findNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.entry == null && !this.findNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<K, V> next = this.entry;
            this.entry = null;
            return next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private final class Entries
    extends AbstractSet<Map.Entry<K, V>> {
        private Entries() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iter(SoftValueHashMap.this.hash);
        }

        @Override
        public int size() {
            return SoftValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object entry) {
            return super.contains(entry);
        }

        @Override
        public Object[] toArray() {
            return super.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return super.toArray(array);
        }

        @Override
        public boolean remove(Object entry) {
            return super.remove(entry);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return super.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            return super.addAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return super.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return super.retainAll(collection);
        }

        @Override
        public void clear() {
            SoftValueHashMap.this.clear();
        }

        @Override
        public String toString() {
            return super.toString();
        }
    }
}

