/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.common;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndianOutput;

public final class FtrHeader {
    private short recordType;
    private short grbitFrt;
    private byte[] reserved;

    public FtrHeader() {
        this.reserved = new byte[8];
    }

    public FtrHeader(RecordInputStream recordInputStream) {
        this.recordType = recordInputStream.readShort();
        this.grbitFrt = recordInputStream.readShort();
        this.reserved = new byte[8];
        recordInputStream.read(this.reserved, 0, 8);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [FUTURE HEADER]\n");
        stringBuffer.append("   Type " + this.recordType);
        stringBuffer.append("   Flags " + this.grbitFrt);
        stringBuffer.append(" [/FUTURE HEADER]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.recordType);
        littleEndianOutput.writeShort(this.grbitFrt);
        littleEndianOutput.write(this.reserved);
    }

    public void setRecordType(short s) {
        this.recordType = s;
    }
}

