/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public abstract class PageBreakRecord
extends StandardRecord {
    private List<Break> _breaks;
    private Map<Integer, Break> _breakMap;

    protected PageBreakRecord() {
        this._breaks = new ArrayList<Break>();
        this._breakMap = new HashMap<Integer, Break>();
    }

    public PageBreakRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        this._breaks = new ArrayList<Break>(n + 2);
        this._breakMap = new HashMap<Integer, Break>();
        for (int i = 0; i < n; ++i) {
            Break break_ = new Break(recordInputStream);
            this._breaks.add(break_);
            this._breakMap.put(break_.main, break_);
        }
    }

    @Override
    protected int getDataSize() {
        return 2 + this._breaks.size() * 6;
    }

    @Override
    public final void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._breaks.size();
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this._breaks.get(i).serialize(littleEndianOutput);
        }
    }

    public int getNumBreaks() {
        return this._breaks.size();
    }

    public final Iterator<Break> getBreaksIterator() {
        return this._breaks.iterator();
    }

    @Override
    public String toString() {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSid() == 27) {
            string3 = "HORIZONTALPAGEBREAK";
            string2 = "row";
            string = "col";
        } else {
            string3 = "VERTICALPAGEBREAK";
            string2 = "column";
            string = "row";
        }
        stringBuffer.append("[" + string3 + "]").append("\n");
        stringBuffer.append("     .sid        =").append(this.getSid()).append("\n");
        stringBuffer.append("     .numbreaks =").append(this.getNumBreaks()).append("\n");
        Iterator<Break> iterator = this.getBreaksIterator();
        for (int i = 0; i < this.getNumBreaks(); ++i) {
            Break break_ = iterator.next();
            stringBuffer.append("     .").append(string2).append(" (zero-based) =").append(break_.main).append("\n");
            stringBuffer.append("     .").append(string).append("From    =").append(break_.subFrom).append("\n");
            stringBuffer.append("     .").append(string).append("To      =").append(break_.subTo).append("\n");
        }
        stringBuffer.append("[" + string3 + "]").append("\n");
        return stringBuffer.toString();
    }

    public void addBreak(int n, int n2, int n3) {
        Integer n4 = n;
        Break break_ = this._breakMap.get(n4);
        if (break_ == null) {
            break_ = new Break(n, n2, n3);
            this._breakMap.put(n4, break_);
            this._breaks.add(break_);
        } else {
            break_.main = n;
            break_.subFrom = n2;
            break_.subTo = n3;
        }
    }

    public static final class Break {
        public static final int ENCODED_SIZE = 6;
        public int main;
        public int subFrom;
        public int subTo;

        public Break(int n, int n2, int n3) {
            this.main = n;
            this.subFrom = n2;
            this.subTo = n3;
        }

        public Break(RecordInputStream recordInputStream) {
            this.main = recordInputStream.readUShort() - 1;
            this.subFrom = recordInputStream.readUShort();
            this.subTo = recordInputStream.readUShort();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this.main + 1);
            littleEndianOutput.writeShort(this.subFrom);
            littleEndianOutput.writeShort(this.subTo);
        }
    }
}

