/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.opendata.core.actions.DownloadDataAction;
import org.openstreetmap.josm.plugins.opendata.core.actions.DownloadDataTask;
import org.openstreetmap.josm.plugins.opendata.core.actions.OpenPreferencesActions;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdDialog;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.XmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.SevenZipImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlKmzImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifTabImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsImporter;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;

public final class OdPlugin
extends Plugin {
    private static OdPlugin instance;
    public final XmlImporter xmlImporter = new XmlImporter();
    private final JMenu menu;
    private OdDialog dialog;

    public OdPlugin(PluginInformation info) {
        super(info);
        ImageProvider.addAdditionalClassLoaders(ModuleHandler.getResourceClassLoaders());
        if (instance != null) {
            throw new IllegalStateException("Cannot instantiate plugin twice !");
        }
        instance = this;
        for (AbstractImporter importer : Arrays.asList(new AbstractImporter[]{new CsvImporter(), new OdsImporter(), new XlsImporter(), new KmlKmzImporter(), new ShpImporter(), new MifTabImporter(), new GmlImporter(), new ZipImporter(), new SevenZipImporter(), this.xmlImporter})) {
            ExtensionFileFilter.addImporterFirst((FileImporter)importer);
        }
        this.menu = MainApplication.getMenu().dataMenu;
        new Thread(() -> {
            this.loadModules();
            GuiHelper.runInEDT(() -> this.buildMenu());
        }).start();
        MainApplication.getMenu().openLocation.addDownloadTaskClass(DownloadDataTask.class);
        OdUtils.deletePreviousTempDirs();
    }

    public static OdPlugin getInstance() {
        return instance;
    }

    private JMenu getModuleMenu(Module module) {
        String moduleName = module.getDisplayedName();
        if (moduleName == null || moduleName.isEmpty()) {
            moduleName = module.getModuleInformation().getName();
        }
        JMenu moduleMenu = new JMenu(moduleName);
        moduleMenu.setIcon(module.getModuleInformation().getScaledIcon());
        return moduleMenu;
    }

    private void buildMenu() {
        for (Module module : ModuleHandler.moduleList) {
            HashMap<DataSetCategory, JMenu> catMenus = new HashMap<DataSetCategory, JMenu>();
            JMenu moduleMenu = null;
            for (AbstractDataSetHandler handler : module.getNewlyInstanciatedHandlers()) {
                String handlerName;
                URL dataURL = handler.getDataURL();
                List<Pair<String, URL>> dataURLs = handler.getDataURLs();
                if (dataURL == null && (dataURLs == null || dataURLs.isEmpty())) continue;
                if (moduleMenu == null) {
                    moduleMenu = this.getModuleMenu(module);
                }
                DataSetCategory cat = handler.getCategory();
                JMenu endMenu = null;
                if (cat != null && (endMenu = (JMenu)catMenus.get(cat)) == null) {
                    endMenu = new JMenu(cat.getName());
                    catMenus.put(cat, endMenu);
                    this.setMenuItemIcon(cat.getIcon(), endMenu);
                    moduleMenu.add(endMenu);
                }
                if (endMenu == null) {
                    endMenu = moduleMenu;
                }
                if ((handlerName = handler.getName()) == null || handlerName.isEmpty()) {
                    handlerName = handler.getClass().getName();
                }
                JMenuItem handlerItem = null;
                if (dataURL != null) {
                    handlerItem = endMenu.add((Action)((Object)new DownloadDataAction(module, handlerName, dataURL)));
                } else if (dataURLs != null) {
                    JMenu handlerMenu = new JMenu(handlerName);
                    JMenuItem item = null;
                    for (Pair<String, URL> pair : dataURLs) {
                        if (pair == null || pair.a == null || pair.b == null) continue;
                        item = handlerMenu.add((Action)((Object)new DownloadDataAction(module, (String)pair.a, (URL)pair.b)));
                    }
                    if (item != null) {
                        MenuScroller.setScrollerFor((JMenu)handlerMenu);
                        handlerItem = endMenu.add(handlerMenu);
                    }
                }
                if (handlerItem == null) continue;
                this.setMenuItemIcon(handler.getMenuIcon(), handlerItem);
            }
            if (moduleMenu == null) continue;
            this.menu.add(moduleMenu);
        }
        this.menu.addSeparator();
        MainMenu.add((JMenu)this.menu, (JosmAction)new OpenPreferencesActions());
    }

    private void setMenuItemIcon(ImageIcon icon, JMenuItem menuItem) {
        if (icon != null) {
            if (icon.getIconHeight() != 16 || icon.getIconWidth() != 16) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(16, 16, 1));
            }
            menuItem.setIcon(icon);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.dialog = new OdDialog();
            newFrame.addToggleDialog((ToggleDialog)this.dialog);
        } else {
            this.dialog = null;
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new OdPreferenceSetting();
    }

    private void loadModules() {
        MainFrame parent = MainApplication.getMainFrame();
        List<ModuleInformation> modulesToLoad = ModuleHandler.buildListOfModulesToLoad((Component)parent);
        if (!modulesToLoad.isEmpty() && ModuleHandler.checkAndConfirmModuleUpdate((Component)parent)) {
            modulesToLoad = ModuleHandler.updateModules((Component)parent, modulesToLoad, null);
        }
        ModuleHandler.installDownloadedModules(true);
        ModuleHandler.loadModules((Component)parent, modulesToLoad, null);
    }

    private File getSubDirectory(String name) {
        File dir = new File(this.getPluginDirs().getUserDataDirectory(false), name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public File getModulesDirectory() {
        return this.getSubDirectory("modules");
    }

    public File getResourcesDirectory() {
        return this.getSubDirectory("resources");
    }

    public OdDialog getDialog() {
        return this.dialog;
    }
}

