/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.contour;

import java.awt.image.RenderedImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.jaitools.CollectionFactory;
import org.jaitools.jts.LineSmoother;
import org.jaitools.jts.SmootherControl;
import org.jaitools.jts.Utils;
import org.jaitools.media.jai.AttributeOpImage;
import org.jaitools.media.jai.contour.Segments;
import org.jaitools.numeric.CompareOp;
import org.jaitools.numeric.Range;
import org.locationtech.jts.geom.LineString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourOpImage
extends AttributeOpImage {
    private static final int BL_VERTEX1 = 0;
    private static final int BR_VERTEX2 = 1;
    private static final int TR_VERTEX3 = 2;
    private static final int TL_VERTEX4 = 3;
    private int band;
    private List<Double> contourLevels;
    private Double contourInterval;
    private List<Double> noDataNumbers;
    private List<Range<Double>> noDataRanges;
    private final boolean strictNodata;
    private SoftReference<List<LineString>> cachedContours;
    private final boolean simplify;
    private final boolean smooth;
    private double smoothAlpha = 0.0;
    private final SmootherControl smootherControl = new SmootherControl(){

        public double getMinLength() {
            return 0.1;
        }

        public int getNumVertices(double length) {
            return (int)Math.max(5.0, length * 10.0);
        }
    };

    public ContourOpImage(RenderedImage source, ROI roi, int band, Collection<? extends Number> levels, Double interval, Collection<Object> noDataValues, boolean strictNodata, boolean simplify, boolean smooth) {
        super(source, roi);
        this.band = band;
        if (levels != null) {
            this.contourLevels = new ArrayList<Double>();
            for (Number number : levels) {
                this.contourLevels.add(number.doubleValue());
            }
            Collections.sort(this.contourLevels);
        } else if (interval != null && !interval.isNaN()) {
            this.contourInterval = interval;
        } else {
            throw new IllegalArgumentException("At least one of levels or interval must be supplied");
        }
        this.noDataNumbers = CollectionFactory.list();
        this.noDataRanges = CollectionFactory.list();
        if (noDataValues != null) {
            for (Object object : noDataValues) {
                if (object instanceof Number) {
                    double dz = ((Number)object).doubleValue();
                    if (Double.isNaN(dz) || Double.isInfinite(dz) || Double.compare(dz, Double.MAX_VALUE) == 0) continue;
                    this.noDataNumbers.add(dz);
                    continue;
                }
                if (object instanceof Range) {
                    Range r = (Range)object;
                    Double min = ((Number)r.getMin()).doubleValue();
                    Double max = ((Number)r.getMax()).doubleValue();
                    Range<Double> rd = new Range<Double>(min, r.isMinIncluded(), max, r.isMaxIncluded());
                    this.noDataRanges.add(rd);
                    continue;
                }
                throw new IllegalArgumentException("only Number and Range elements are permitted in the noDataValues Collection");
            }
        }
        this.strictNodata = strictNodata;
        this.simplify = simplify;
        this.smooth = smooth;
        Utils.setPrecision(100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttribute(String name) {
        if (this.cachedContours == null || this.cachedContours.get() == null) {
            ContourOpImage contourOpImage = this;
            synchronized (contourOpImage) {
                this.cachedContours = new SoftReference<List<LineString>>(this.createContours());
            }
        }
        return this.cachedContours.get();
    }

    protected String[] getAttributeNames() {
        return new String[]{"contours"};
    }

    protected Class<?> getAttributeClass(String name) {
        if ("contours".equalsIgnoreCase(name)) {
            return List.class;
        }
        return super.getAttributeClass(name);
    }

    private List<LineString> createContours() {
        if (this.contourLevels == null) {
            this.contourLevels = this.buildContourLevels();
        }
        Map<Integer, Segments> segments = this.getContourSegments();
        ArrayList<LineString> mergedContourLines = new ArrayList<LineString>();
        int levelIndex = 0;
        for (Double levelValue : this.contourLevels) {
            Segments levelSegments = segments.remove(levelIndex);
            if (levelSegments != null) {
                List<LineString> levelContours = levelSegments.getMergedSegments();
                for (LineString line : levelContours) {
                    line.setUserData((Object)levelValue);
                }
                mergedContourLines.addAll(levelContours);
            }
            ++levelIndex;
        }
        if (this.smooth) {
            LineSmoother smoother = new LineSmoother(Utils.getGeometryFactory());
            smoother.setControl(this.smootherControl);
            int N = mergedContourLines.size();
            for (int i = N - 1; i >= 0; --i) {
                LineString contour = (LineString)mergedContourLines.remove(i);
                LineString smoothed = smoother.smooth(contour, this.smoothAlpha);
                mergedContourLines.add(smoothed);
            }
        }
        return mergedContourLines;
    }

    private Map<Integer, Segments> getContourSegments() {
        HashMap<Integer, Segments> segments = new HashMap<Integer, Segments>();
        double[] sample = new double[4];
        boolean[] nodata = new boolean[4];
        double[] h = new double[5];
        double[] xh = new double[5];
        double[] yh = new double[5];
        int[] sh = new int[5];
        int[][][] configLookup = new int[][][]{new int[][]{{0, 0, 8}, {0, 2, 5}, {7, 6, 9}}, new int[][]{{0, 3, 4}, {1, 3, 1}, {4, 3, 0}}, new int[][]{{9, 6, 7}, {5, 2, 0}, {8, 0, 0}}};
        PlanarImage src = this.getSourceImage(0);
        RectIter iter1 = RectIterFactory.create(src, src.getBounds());
        RectIter iter2 = RectIterFactory.create(src, src.getBounds());
        this.moveIterToBand(iter1, this.band);
        this.moveIterToBand(iter2, this.band);
        iter1.startLines();
        iter2.startLines();
        iter2.nextLine();
        int y = (int)src.getBounds().getMinY();
        while (!iter2.finishedLines() && !iter1.finishedLines()) {
            iter1.startPixels();
            iter2.startPixels();
            sample[1] = iter1.getSampleDouble();
            nodata[1] = this.isNoData(sample[1]);
            sample[2] = iter2.getSampleDouble();
            nodata[2] = this.isNoData(sample[2]);
            iter1.nextPixel();
            iter2.nextPixel();
            int x = (int)src.getBounds().getMinX() + 1;
            while (!iter1.finishedPixels() && !iter2.finishedPixels()) {
                sample[0] = sample[1];
                nodata[0] = nodata[1];
                sample[1] = iter1.getSampleDouble();
                nodata[1] = this.isNoData(sample[1]);
                sample[3] = sample[2];
                nodata[3] = nodata[2];
                sample[2] = iter2.getSampleDouble();
                nodata[2] = this.isNoData(sample[2]);
                boolean processSquare = true;
                boolean hasSingleNoData = false;
                for (int i = 0; i < 4 && processSquare; ++i) {
                    if (!nodata[i]) continue;
                    if (this.strictNodata || hasSingleNoData) {
                        processSquare = false;
                        break;
                    }
                    hasSingleNoData = true;
                }
                if (processSquare) {
                    double temp2;
                    double temp4;
                    double temp1;
                    double temp3;
                    if (nodata[0]) {
                        temp1 = temp3 = sample[3];
                    } else if (nodata[3]) {
                        temp1 = temp3 = sample[0];
                    } else {
                        temp1 = Math.min(sample[0], sample[3]);
                        temp3 = Math.max(sample[0], sample[3]);
                    }
                    if (nodata[1]) {
                        temp2 = temp4 = sample[2];
                    } else if (nodata[2]) {
                        temp2 = temp4 = sample[1];
                    } else {
                        temp2 = Math.min(sample[1], sample[2]);
                        temp4 = Math.max(sample[1], sample[2]);
                    }
                    double dmin = Math.min(temp1, temp2);
                    double dmax = Math.max(temp3, temp4);
                    int size = this.contourLevels.size();
                    for (int levelIndex = 0; levelIndex < size; ++levelIndex) {
                        double levelValue = this.contourLevels.get(levelIndex);
                        if (levelValue < dmin || levelValue > dmax) continue;
                        Segments zlist = (Segments)segments.get(levelIndex);
                        if (zlist == null) {
                            zlist = new Segments(this.simplify);
                            segments.put(levelIndex, zlist);
                        }
                        if (!nodata[3]) {
                            h[4] = sample[3] - levelValue;
                            xh[4] = x - 1;
                            yh[4] = y + 1;
                            sh[4] = this.aboveBelowZero(h[4]);
                        }
                        if (!nodata[2]) {
                            h[3] = sample[2] - levelValue;
                            xh[3] = x;
                            yh[3] = y + 1;
                            sh[3] = this.aboveBelowZero(h[3]);
                        }
                        if (!nodata[1]) {
                            h[2] = sample[1] - levelValue;
                            xh[2] = x;
                            yh[2] = y;
                            sh[2] = this.aboveBelowZero(h[2]);
                        }
                        if (!nodata[0]) {
                            h[1] = sample[0] - levelValue;
                            xh[1] = x - 1;
                            yh[1] = y;
                            sh[1] = this.aboveBelowZero(h[1]);
                        }
                        h[0] = 0.0;
                        int nh = 0;
                        for (int i = 0; i < 4; ++i) {
                            if (nodata[i]) continue;
                            h[0] = h[0] + h[i + 1];
                            ++nh;
                        }
                        if (nh < 3) {
                            throw new IllegalStateException("Internal error: number data vertices = " + nh);
                        }
                        h[0] = h[0] / (double)nh;
                        xh[0] = (double)x - 0.5;
                        yh[0] = (double)y + 0.5;
                        sh[0] = this.aboveBelowZero(h[0]);
                        for (int m = 1; m <= 4; ++m) {
                            int config;
                            int m3;
                            int m1 = m;
                            int m2 = 0;
                            int n = m3 = m == 4 ? 1 : m + 1;
                            if (nodata[m1 - 1] || nodata[m3 - 1] || (config = configLookup[sh[m1] + 1][sh[m2] + 1][sh[m3] + 1]) == 0) continue;
                            double x0 = 0.0;
                            double y0 = 0.0;
                            double x1 = 0.0;
                            double y1 = 0.0;
                            boolean addSegment = true;
                            switch (config) {
                                case 1: {
                                    x0 = xh[m1];
                                    y0 = yh[m1];
                                    x1 = xh[m2];
                                    y1 = yh[m2];
                                    break;
                                }
                                case 2: {
                                    x0 = xh[m2];
                                    y0 = yh[m2];
                                    x1 = xh[m3];
                                    y1 = yh[m3];
                                    break;
                                }
                                case 3: {
                                    if (m == 2 || m == 3) {
                                        x0 = xh[m3];
                                        y0 = yh[m3];
                                        x1 = xh[m1];
                                        y1 = yh[m1];
                                        break;
                                    }
                                    addSegment = false;
                                    break;
                                }
                                case 4: {
                                    x0 = xh[m1];
                                    y0 = yh[m1];
                                    x1 = ContourOpImage.sect(m2, m3, h, xh);
                                    y1 = ContourOpImage.sect(m2, m3, h, yh);
                                    break;
                                }
                                case 5: {
                                    x0 = xh[m2];
                                    y0 = yh[m2];
                                    x1 = ContourOpImage.sect(m3, m1, h, xh);
                                    y1 = ContourOpImage.sect(m3, m1, h, yh);
                                    break;
                                }
                                case 6: {
                                    x0 = xh[m3];
                                    y0 = yh[m3];
                                    x1 = ContourOpImage.sect(m1, m2, h, xh);
                                    y1 = ContourOpImage.sect(m1, m2, h, yh);
                                    break;
                                }
                                case 7: {
                                    x0 = ContourOpImage.sect(m1, m2, h, xh);
                                    y0 = ContourOpImage.sect(m1, m2, h, yh);
                                    x1 = ContourOpImage.sect(m2, m3, h, xh);
                                    y1 = ContourOpImage.sect(m2, m3, h, yh);
                                    break;
                                }
                                case 8: {
                                    x0 = ContourOpImage.sect(m2, m3, h, xh);
                                    y0 = ContourOpImage.sect(m2, m3, h, yh);
                                    x1 = ContourOpImage.sect(m3, m1, h, xh);
                                    y1 = ContourOpImage.sect(m3, m1, h, yh);
                                    break;
                                }
                                case 9: {
                                    x0 = ContourOpImage.sect(m3, m1, h, xh);
                                    y0 = ContourOpImage.sect(m3, m1, h, yh);
                                    x1 = ContourOpImage.sect(m1, m2, h, xh);
                                    y1 = ContourOpImage.sect(m1, m2, h, yh);
                                }
                            }
                            if (!addSegment) continue;
                            zlist.add(x0, y0, x1, y1);
                        }
                    }
                }
                iter1.nextPixel();
                iter2.nextPixel();
                ++x;
            }
            iter1.nextLine();
            iter2.nextLine();
            this.lineComplete(segments, y);
            ++y;
        }
        this.lineComplete(segments, y);
        return segments;
    }

    private void lineComplete(Map<Integer, Segments> segments, int line) {
        for (Segments s : segments.values()) {
            s.lineComplete(line);
        }
    }

    private int aboveBelowZero(double h) {
        int result = Double.compare(h, 0.0);
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    private static double sect(int p1, int p2, double[] h, double[] coord) {
        return (h[p2] * coord[p1] - h[p1] * coord[p2]) / (h[p2] - h[p1]);
    }

    private List<Double> buildContourLevels() {
        double minVal = 0.0;
        double maxVal = 0.0;
        boolean first = true;
        RectIter iter = RectIterFactory.create(this.getSourceImage(0), this.getBounds());
        boolean hasNonNan = false;
        this.moveIterToBand(iter, this.band);
        iter.startLines();
        while (!iter.finishedLines()) {
            iter.startPixels();
            while (!iter.finishedPixels()) {
                double val = iter.getSampleDouble();
                if (!Double.isNaN(val)) {
                    hasNonNan = true;
                    if (first) {
                        minVal = maxVal = val;
                        first = false;
                    } else if (val < minVal) {
                        minVal = val;
                    } else if (val > maxVal) {
                        maxVal = val;
                    }
                }
                iter.nextPixel();
            }
            iter.nextLine();
        }
        if (!hasNonNan) {
            return Collections.emptyList();
        }
        double z = Math.floor(minVal / this.contourInterval) * this.contourInterval;
        if (CompareOp.acompare(z, minVal) < 0) {
            z += this.contourInterval.doubleValue();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        while (CompareOp.acompare(z, maxVal) <= 0) {
            result.add(z);
            z += this.contourInterval.doubleValue();
        }
        return result;
    }

    private void moveIterToBand(RectIter iter, int targetBand) {
        int iband;
        iter.startBands();
        for (iband = 0; iband < targetBand && !iter.nextBandDone(); ++iband) {
        }
        if (iband != targetBand) {
            throw new IllegalArgumentException("Band " + targetBand + " not found, max band is " + iband);
        }
    }

    private boolean isNoData(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value) || Double.compare(value, Double.MAX_VALUE) == 0) {
            return true;
        }
        for (Double d : this.noDataNumbers) {
            if (!CompareOp.aequal(value, d)) continue;
            return true;
        }
        for (Range range : this.noDataRanges) {
            if (!range.contains(value)) continue;
            return true;
        }
        return false;
    }
}

