/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.Classes;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.XArray;
import org.geotools.util.logging.LoggerFactory;
import org.geotools.util.logging.LoggingImagingListener;
import org.geotools.util.logging.MonolineFormatter;

public final class Logging {
    private static final Comparator<Object> COMPARATOR;
    private static final Logging[] EMPTY;
    public static final Logging ALL;
    public static final Logging GEOTOOLS;
    final String name;
    private Logging[] children = EMPTY;
    private LoggerFactory<?> factory;
    private static boolean sameLoggerFactory;

    private Logging() {
        this.name = "";
    }

    private Logging(Logging parent, String name) {
        this.name = name;
        this.factory = parent.factory;
        assert (name.startsWith(parent.name)) : name;
    }

    public static Logger getLogger(Class<?> classe) {
        String name = classe.getName();
        int separator = name.lastIndexOf(46);
        name = separator >= 1 ? name.substring(0, separator) : "";
        return Logging.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            Logging logging;
            Logging logging2 = logging = sameLoggerFactory ? ALL : Logging.getLogging(name, false);
            if (logging != null) {
                Logger logger;
                LoggerFactory<?> factory = logging.factory;
                assert (Logging.getLogging((String)name, (boolean)false).factory == factory) : name;
                if (factory != null && (logger = factory.getLogger(name)) != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return logger;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logger.getLogger(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logging getLogging(String name) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Logging.getLogging(name, true);
        }
    }

    private static Logging getLogging(String base, boolean create) {
        assert (Thread.holdsLock(EMPTY));
        Logging logging = ALL;
        if (base.length() != 0) {
            int offset = 0;
            do {
                String name;
                Logging[] children;
                int i;
                if ((i = Arrays.binarySearch(children = logging.children, name = (offset = base.indexOf(46, offset)) >= 0 ? base.substring(0, offset) : base, COMPARATOR)) < 0) {
                    if (!create) break;
                    children = XArray.insert(children, i ^= 0xFFFFFFFF, 1);
                    children[i] = new Logging(logging, name);
                    logging.children = children;
                }
                logging = children[i];
            } while (++offset != 0);
        }
        return logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Logging[] getChildren() {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Logging[])this.children.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerFactory<?> getLoggerFactory() {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggerFactory(LoggerFactory<?> factory) {
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            this.factory = factory;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].setLoggerFactory(factory);
            }
            sameLoggerFactory = Logging.sameLoggerFactory(Logging.ALL.children, Logging.ALL.factory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean sameLoggerFactory(Logging[] children, LoggerFactory<?> factory) {
        assert (Thread.holdsLock(EMPTY));
        for (int i = 0; i < children.length; ++i) {
            Logging logging = children[i];
            if (logging.factory == factory && Logging.sameLoggerFactory(logging.children, factory)) continue;
            return false;
        }
        return true;
    }

    public void setLoggerFactory(String className) throws ClassNotFoundException, IllegalArgumentException {
        LoggerFactory factory;
        if (className == null) {
            factory = null;
        } else {
            Class<?> factoryClass;
            try {
                factoryClass = Class.forName(className);
            }
            catch (NoClassDefFoundError error) {
                throw Logging.factoryNotFound(className, error);
            }
            if (!LoggerFactory.class.isAssignableFrom(factoryClass)) {
                throw new IllegalArgumentException(Errors.format(61, factoryClass, LoggerFactory.class));
            }
            try {
                Method method = factoryClass.getMethod("getInstance", null);
                factory = (LoggerFactory)LoggerFactory.class.cast(method.invoke(null, (Object[])null));
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = e.getCause();
                }
                if (cause instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)e;
                }
                if (cause instanceof NoClassDefFoundError) {
                    throw Logging.factoryNotFound(className, (NoClassDefFoundError)cause);
                }
                throw new IllegalArgumentException(Errors.format(23, className, cause));
            }
        }
        this.setLoggerFactory(factory);
    }

    private static ClassNotFoundException factoryNotFound(String name, NoClassDefFoundError error) {
        return new ClassNotFoundException(Errors.format(49, name), error);
    }

    public void forceMonolineConsoleOutput() {
        this.forceMonolineConsoleOutput(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
    public void forceMonolineConsoleOutput(Level level) {
        Logger logger = Logger.getLogger(this.name);
        Logging[] loggingArray = EMPTY;
        synchronized (EMPTY) {
            Level current;
            MonolineFormatter f = MonolineFormatter.configureConsoleHandler(logger, level);
            if (f.getSourceFormat() == null) {
                f.setSourceFormat("class:short");
            }
            if (level != null && ((current = logger.getLevel()) == null || current.intValue() > level.intValue())) {
                logger.setLevel(level);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static boolean unexpectedException(Logger logger, Throwable error) {
        return Logging.unexpectedException(logger, null, null, error, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.WARNING);
    }

    public static boolean unexpectedException(Class<?> classe, String method, Throwable error) {
        return Logging.unexpectedException(null, classe, method, error);
    }

    private static boolean unexpectedException(Logger logger, String classe, String method, Throwable error, Level level) {
        if (error == null) {
            return false;
        }
        if (logger == null && classe != null) {
            int separator = classe.lastIndexOf(46);
            String paquet = separator >= 1 ? classe.substring(0, separator - 1) : "";
            logger = Logging.getLogger(paquet);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || classe == null || method == null) {
            String paquet = logger != null ? logger.getName() : null;
            StackTraceElement[] elements = error.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                char separator;
                StackTraceElement element = elements[i];
                String classname = element.getClassName();
                if (classe != null) {
                    if (!classname.equals(classe)) {
                        continue;
                    }
                } else if (paquet != null) {
                    if (!classname.startsWith(paquet)) continue;
                    int length = paquet.length();
                    if (classname.length() > length && Character.isJavaIdentifierPart(separator = (char)classname.charAt(length))) continue;
                }
                String methodName = element.getMethodName();
                if (method != null && !methodName.equals(method)) continue;
                if (paquet == null && !(logger = Logging.getLogger(paquet = (separator = classname.lastIndexOf(46)) >= '\u0001' ? classname.substring(0, separator - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (classe == null) {
                    classe = classname;
                }
                if (method != null) break;
                method = methodName;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        LogRecord record = new LogRecord(level, buffer.toString());
        if (classe != null) {
            record.setSourceClassName(classe);
        }
        if (method != null) {
            record.setSourceMethodName(method);
        }
        if (level.intValue() > 500) {
            record.setThrown(error);
        }
        record.setLoggerName(logger.getName());
        logger.log(record);
        return true;
    }

    public static boolean recoverableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINE);
    }

    public static boolean recoverableException(Class<?> classe, String method, Throwable error) {
        return Logging.recoverableException(null, classe, method, error);
    }

    static {
        block6: {
            COMPARATOR = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    String n1 = o1 instanceof Logging ? ((Logging)o1).name : o1.toString();
                    String n2 = o2 instanceof Logging ? ((Logging)o2).name : o2.toString();
                    return n1.compareTo(n2);
                }
            };
            EMPTY = new Logging[0];
            ALL = new Logging();
            GEOTOOLS = Logging.getLogging("org.geotools");
            sameLoggerFactory = true;
            boolean LOGGING_TRACE = Boolean.getBoolean("LOGGING_TRACE");
            try {
                Class<?> JAI2 = Class.forName("javax.media.jai.JAI");
                Class<?> IMAGING_LISTENER = Class.forName("javax.media.jai.util.ImagingListener");
                Method getDefaultInstance = JAI2.getMethod("getDefaultInstance", new Class[0]);
                Method getImagingListener = JAI2.getMethod("getImagingListener", new Class[0]);
                Method setImagingListener = JAI2.getMethod("setImagingListener", IMAGING_LISTENER);
                Object jai = getDefaultInstance.invoke(null, null);
                Object imagingListener = getImagingListener.invoke(jai, null);
                if (imagingListener == null || imagingListener.getClass().getName().contains("ImagingListenerImpl")) {
                    setImagingListener.invoke(jai, new LoggingImagingListener());
                    if (LOGGING_TRACE) {
                        System.out.println("Logging JAI messages: javax.media.jai logger redirected");
                    }
                } else if (LOGGING_TRACE) {
                    System.out.println("Logging JAI messages: ImagingListener already in use: " + imagingListener);
                }
            }
            catch (Throwable ignore) {
                if (!LOGGING_TRACE) break block6;
                System.out.println("Logging JAI messages: Unable to redirect to javax.media.jai");
            }
        }
    }
}

