/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.Description;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Symbolizer;
import org.opengis.util.Cloneable;

public class LineSymbolizerImpl
extends AbstractSymbolizer
implements LineSymbolizer,
Cloneable {
    private Expression offset;
    private StrokeImpl stroke = null;

    protected LineSymbolizerImpl() {
        this(null, null, null, null, null, null);
    }

    protected LineSymbolizerImpl(Stroke stroke, Expression offset, Unit<Length> uom, String geom, String name, Description desc) {
        super(name, desc, geom, uom);
    }

    @Override
    public Expression getPerpendicularOffset() {
        return this.offset;
    }

    @Override
    public void setPerpendicularOffset(Expression offset) {
        this.offset = offset;
    }

    @Override
    public StrokeImpl getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(org.opengis.style.Stroke stroke) {
        if (this.stroke == stroke) {
            return;
        }
        this.stroke = StrokeImpl.cast(stroke);
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        LineSymbolizerImpl clone;
        try {
            clone = (LineSymbolizerImpl)super.clone();
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<LineSymbolizerImp property=");
        buf.append(this.getGeometryPropertyName());
        buf.append(" uom=");
        buf.append(this.unitOfMeasure);
        buf.append(" stroke=");
        buf.append(this.stroke);
        buf.append(">");
        return buf.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.stroke == null ? 0 : this.stroke.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineSymbolizerImpl other = (LineSymbolizerImpl)obj;
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    static LineSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof LineSymbolizerImpl) {
            return (LineSymbolizerImpl)symbolizer;
        }
        if (symbolizer instanceof org.opengis.style.LineSymbolizer) {
            org.opengis.style.LineSymbolizer lineSymbolizer = (org.opengis.style.LineSymbolizer)symbolizer;
            LineSymbolizerImpl copy = new LineSymbolizerImpl();
            copy.setDescription(lineSymbolizer.getDescription());
            copy.setGeometryPropertyName(lineSymbolizer.getGeometryPropertyName());
            copy.setName(lineSymbolizer.getName());
            copy.setPerpendicularOffset(lineSymbolizer.getPerpendicularOffset());
            copy.setStroke(lineSymbolizer.getStroke());
            copy.setUnitOfMeasure(lineSymbolizer.getUnitOfMeasure());
            return copy;
        }
        return null;
    }
}

