/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class Decimator {
    private static final Logger LOGGER = Logging.getLogger(Decimator.class);
    static final double DP_THRESHOLD;
    private static final double EPS = 1.0E-9;
    private double spanx = -1.0;
    private double spany = -1.0;

    public Decimator(MathTransform screenToWorld, Rectangle paintArea, double pixelDistance) {
        if (screenToWorld != null && pixelDistance > 0.0) {
            try {
                double[] spans = Decimator.computeGeneralizationDistances(screenToWorld, paintArea, pixelDistance);
                this.spanx = spans[0];
                this.spany = spans[1];
            }
            catch (TransformException e) {
                throw new RuntimeException("Could not perform the generalization spans computation", e);
            }
        } else {
            this.spanx = 1.0;
            this.spany = 1.0;
        }
    }

    public double getSpanX() {
        return this.spanx;
    }

    public double getSpanY() {
        return this.spany;
    }

    public Decimator(MathTransform screenToWorld, Rectangle paintArea) {
        this(screenToWorld, paintArea, 0.8);
    }

    public static double[] computeGeneralizationDistances(MathTransform screenToWorld, Rectangle paintArea, double pixelDistance) throws TransformException {
        try {
            double[] spans = Decimator.getGeneralizationSpans(paintArea.x, paintArea.y, screenToWorld);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    double[] ns = Decimator.getGeneralizationSpans((double)paintArea.x + (double)(paintArea.width * i) / 2.0, (double)paintArea.y + (double)paintArea.height / 2.0, screenToWorld);
                    if (Decimator.isFinite(ns[0]) && (ns[0] < spans[0] || !Decimator.isFinite(spans[0]))) {
                        spans[0] = ns[0];
                    }
                    if (!Decimator.isFinite(ns[1]) || !(ns[1] < spans[1]) && Decimator.isFinite(spans[1])) continue;
                    spans[1] = ns[1];
                }
            }
            if (!Decimator.isFinite(spans[0])) {
                spans[0] = 0.0;
            }
            if (!Decimator.isFinite(spans[1])) {
                spans[1] = 0.0;
            }
            spans[0] = spans[0] * pixelDistance;
            spans[1] = spans[1] * pixelDistance;
            return spans;
        }
        catch (TransformException e) {
            return new double[]{0.0, 0.0};
        }
    }

    private static boolean isFinite(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    static double[] getGeneralizationSpans(double x, double y, MathTransform transform) throws TransformException {
        double[] original = new double[]{x - 0.5, y - 0.5, x + 0.5, y + 0.5};
        double[] transformed = new double[4];
        transform.transform(original, 0, transformed, 0, 2);
        double[] spans = new double[]{Math.abs(transformed[0] - transformed[2]), Math.abs(transformed[1] - transformed[3])};
        return spans;
    }

    public Decimator(double spanx, double spany) {
        this.spanx = spanx;
        this.spany = spany;
    }

    public final Geometry decimateTransformGeneralize(Geometry geometry, MathTransform transform) throws TransformException {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            int length = collection.getNumGeometries();
            boolean cloned = false;
            Class elementType = null;
            Geometry[] elements = null;
            for (int i = 0; i < length; ++i) {
                Geometry source = collection.getGeometryN(i);
                Geometry generalized = this.decimateTransformGeneralize(source, transform);
                if (generalized != source) {
                    cloned = true;
                    if (elements == null) {
                        elements = new Geometry[collection.getNumGeometries()];
                        for (int j = 0; j < i; ++j) {
                            Geometry element;
                            elements[j] = element = collection.getGeometryN(j);
                            this.accumulateGeometryType(elementType, element);
                        }
                    }
                }
                if (!cloned) continue;
                elements[i] = generalized;
                elementType = this.accumulateGeometryType(elementType, generalized);
            }
            if (cloned) {
                if (elementType == Point.class) {
                    Point[] points = new Point[elements.length];
                    System.arraycopy(elements, 0, points, 0, elements.length);
                    return collection.getFactory().createMultiPoint(points);
                }
                if (elementType == LineString.class) {
                    LineString[] lines = new LineString[elements.length];
                    System.arraycopy(elements, 0, lines, 0, elements.length);
                    return collection.getFactory().createMultiLineString(lines);
                }
                if (elementType == Polygon.class) {
                    Polygon[] polys = new Polygon[elements.length];
                    System.arraycopy(elements, 0, polys, 0, elements.length);
                    return collection.getFactory().createMultiPolygon(polys);
                }
                return collection.getFactory().createGeometryCollection(elements);
            }
            return collection;
        }
        if (geometry instanceof Point) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((Point)geometry).getCoordinateSequence();
            this.decimateTransformGeneralize(seq, transform, false, this.spanx, this.spany);
            return geometry;
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            LinearRing shell = (LinearRing)this.decimateTransformGeneralize((Geometry)polygon.getExteriorRing(), transform);
            boolean cloned = shell != polygon.getExteriorRing();
            int length = polygon.getNumInteriorRing();
            LinearRing[] holes = cloned ? new LinearRing[length] : null;
            for (int i = 0; i < length; ++i) {
                LineString hole = polygon.getInteriorRingN(i);
                LinearRing generalized = (LinearRing)this.decimateTransformGeneralize((Geometry)hole, transform);
                if (!(cloned |= generalized != hole)) continue;
                if (holes == null) {
                    holes = new LinearRing[length];
                    for (int j = 0; j < i; ++j) {
                        holes[j] = (LinearRing)polygon.getInteriorRingN(j);
                    }
                }
                holes[i] = generalized;
            }
            if (cloned) {
                return polygon.getFactory().createPolygon(shell, holes);
            }
            return polygon;
        }
        if (geometry instanceof LineString) {
            double spanx = this.spanx;
            double spany = this.spany;
            Object ls = (LineString)geometry;
            if (ls instanceof CurvedGeometry) {
                CurvedGeometry curved = (CurvedGeometry)ls;
                ls = (LineString)curved.linearize(Math.min(Math.abs(spanx), Math.abs(spany)));
                spanx = -1.0;
                spany = -1.0;
            }
            CoordinateSequence originalSequence = ls.getCoordinateSequence();
            LiteCoordinateSequence seq = LiteCoordinateSequenceFactory.lite(originalSequence);
            boolean loop = ls instanceof LinearRing;
            if (!loop && seq.size() > 1) {
                double x0 = seq.getOrdinate(0, 0);
                double y0 = seq.getOrdinate(0, 1);
                double x1 = seq.getOrdinate(seq.size() - 1, 0);
                double y1 = seq.getOrdinate(seq.size() - 1, 1);
                loop = Math.abs(x0 - x1) < 1.0E-9 && Math.abs(y0 - y1) < 1.0E-9;
            }
            this.decimateTransformGeneralize(seq, transform, loop, spanx, spany);
            if (seq != originalSequence) {
                ls = loop ? ls.getFactory().createLinearRing((CoordinateSequence)seq) : ls.getFactory().createLineString((CoordinateSequence)seq);
            }
            return ls;
        }
        return geometry;
    }

    private Class accumulateGeometryType(Class elementType, Geometry generalized) {
        Class<?> geometryType = generalized.getClass();
        if (elementType == null) {
            elementType = geometryType;
        } else if (elementType != geometryType && elementType != Geometry.class && !elementType.isAssignableFrom(geometryType)) {
            elementType = geometryType.isAssignableFrom(elementType) ? geometryType : Geometry.class;
        }
        return elementType;
    }

    public final void decimate(Geometry geom) {
        block6: {
            block7: {
                block5: {
                    if (this.spanx == -1.0) {
                        return;
                    }
                    if (geom instanceof MultiPoint) {
                        return;
                    }
                    if (!(geom instanceof GeometryCollection)) break block5;
                    GeometryCollection collection = (GeometryCollection)geom;
                    int numGeometries = collection.getNumGeometries();
                    for (int i = 0; i < numGeometries; ++i) {
                        this.decimate(collection.getGeometryN(i));
                    }
                    break block6;
                }
                if (!(geom instanceof LineString)) break block7;
                LineString line = (LineString)geom;
                LiteCoordinateSequence seq = (LiteCoordinateSequence)line.getCoordinateSequence();
                if (this.decimateOnEnvelope((Geometry)line, seq)) {
                    return;
                }
                this.decimate((Geometry)line, seq);
                break block6;
            }
            if (!(geom instanceof Polygon)) break block6;
            Polygon line = (Polygon)geom;
            this.decimate((Geometry)line.getExteriorRing());
            int numRings = line.getNumInteriorRing();
            for (int i = 0; i < numRings; ++i) {
                this.decimate((Geometry)line.getInteriorRingN(i));
            }
        }
    }

    private boolean decimateOnEnvelope(Geometry geom, LiteCoordinateSequence seq) {
        Envelope env = geom.getEnvelopeInternal();
        if (env.getWidth() <= this.spanx && env.getHeight() <= this.spany) {
            if (geom instanceof LinearRing) {
                this.decimateRingFully(seq);
                return true;
            }
            double[] coords = seq.getArray();
            int dim = seq.getDimension();
            double[] newcoords = new double[dim * 2];
            for (int i = 0; i < dim; ++i) {
                newcoords[i] = coords[i];
                newcoords[dim + i] = coords[coords.length - dim + i];
            }
            seq.setArray(newcoords);
            return true;
        }
        return false;
    }

    private void decimateRingFully(LiteCoordinateSequence seq) {
        double[] coords = seq.getArray();
        int dim = seq.getDimension();
        if (seq.size() <= 4) {
            return;
        }
        double[] newcoords = new double[dim * 4];
        for (int i = 0; i < dim; ++i) {
            newcoords[i] = coords[i];
            newcoords[dim + i] = coords[dim + i];
            newcoords[dim * 2 + i] = coords[coords.length - dim * 2 + i];
            newcoords[dim * 3 + i] = coords[coords.length - dim + i];
        }
        seq.setArray(newcoords);
    }

    private final void decimateTransformGeneralize(LiteCoordinateSequence seq, MathTransform transform, boolean ring, double spanx, double spany) throws TransformException {
        int ncoords = seq.size();
        double[] coords = null;
        int sourceDimensions = 2;
        if (transform != null) {
            sourceDimensions = transform.getSourceDimensions();
            coords = seq.getOrdinateArray(sourceDimensions);
        } else {
            coords = seq.getXYArray();
        }
        if (ncoords < 2) {
            if (ncoords == 1) {
                if (transform != null) {
                    transform.transform(coords, 0, coords, 0, 1);
                    if (sourceDimensions > 2) {
                        double[] flatCoords = new double[seq.size() * 2];
                        for (int i = 0; i < seq.size(); ++i) {
                            flatCoords[i * 2] = coords[i * sourceDimensions];
                            flatCoords[i * 2 + 1] = coords[i * sourceDimensions + 1];
                        }
                        seq.setArray(flatCoords, 2);
                    } else {
                        seq.setArray(coords, 2);
                    }
                }
                return;
            }
            return;
        }
        if (spanx == -1.0 && spany == -1.0) {
            if (transform != null && !transform.isIdentity()) {
                transform.transform(coords, 0, coords, 0, ncoords);
                seq.setArray(coords, 2);
            }
            return;
        }
        int actualCoords = this.spanBasedGeneralize(ncoords, coords, spanx, spany);
        if (DP_THRESHOLD > 0.0 && (double)actualCoords > DP_THRESHOLD) {
            actualCoords = this.dpBasedGeneralize(actualCoords, coords, Math.min(spanx, spany) * Math.min(spanx, spany));
        }
        if (ring && actualCoords <= 3) {
            if (coords.length > 6) {
                coords[2] = coords[2];
                coords[3] = coords[3];
                coords[4] = coords[4];
                coords[5] = coords[5];
                actualCoords = 3;
            } else if (coords.length > 4) {
                coords[2] = coords[2];
                coords[3] = coords[3];
                actualCoords = 2;
            }
        }
        coords[actualCoords * 2] = coords[(ncoords - 1) * 2];
        coords[actualCoords * 2 + 1] = coords[(ncoords - 1) * 2 + 1];
        ++actualCoords;
        if (transform != null && !transform.isIdentity()) {
            transform.transform(coords, 0, coords, 0, actualCoords);
        }
        if (actualCoords * 2 < coords.length) {
            double[] seqDouble = new double[2 * actualCoords];
            System.arraycopy(coords, 0, seqDouble, 0, actualCoords * 2);
            seq.setArray(seqDouble, 2);
        } else {
            seq.setArray(coords, 2);
        }
    }

    private int spanBasedGeneralize(int ncoords, double[] coords, double spanx, double spany) {
        int actualCoords = 1;
        double lastX = coords[0];
        double lastY = coords[1];
        for (int t = 1; t < ncoords - 1; ++t) {
            double x = coords[t * 2];
            double y = coords[t * 2 + 1];
            if (!(Math.abs(x - lastX) > spanx) && !(Math.abs(y - lastY) > spany)) continue;
            coords[actualCoords * 2] = x;
            coords[actualCoords * 2 + 1] = y;
            lastX = x;
            lastY = y;
            ++actualCoords;
        }
        return actualCoords;
    }

    private int dpBasedGeneralize(int ncoords, double[] coords, double maxDistance) {
        while (coords[0] == coords[(ncoords - 1) * 2] && coords[1] == coords[2 * ncoords - 1] && ncoords > 0) {
            --ncoords;
        }
        if (ncoords == 0) {
            return 0;
        }
        this.dpSimplifySection(0, ncoords - 1, coords, maxDistance);
        int actualCoords = 1;
        for (int i = 1; i < ncoords - 1; ++i) {
            double x = coords[i * 2];
            double y = coords[i * 2 + 1];
            if (Double.isNaN(x)) continue;
            coords[actualCoords * 2] = x;
            coords[actualCoords * 2 + 1] = y;
            ++actualCoords;
        }
        return actualCoords;
    }

    private void dpSimplifySection(int first, int last, double[] coords, double maxDistanceSquared) {
        int i;
        if (last - 1 <= first) {
            return;
        }
        double x0 = coords[first * 2];
        double y0 = coords[first * 2 + 1];
        double x1 = coords[last * 2];
        double y1 = coords[last * 2 + 1];
        double dx = x1 - x0;
        double dy = y1 - y0;
        double ls = dx * dx + dy * dy;
        int idx = -1;
        double dsmax = -1.0;
        for (i = first + 1; i < last; ++i) {
            double ds;
            double x = coords[i * 2];
            double y = coords[i * 2 + 1];
            double r = ((x - x0) * dx + (y - y0) * dy) / ls;
            if (r <= 0.0) {
                ds = (x - x0) * (x - x0) + (y - y0) * (y - y0);
            } else if (r >= 1.0) {
                ds = (x - x1) * (x - x1) + (y - y1) * (y - y1);
            } else {
                double s = ((y0 - y) * dx - (x0 - x) * dy) / ls;
                ds = s * s * ls;
            }
            if (idx != -1 && !(ds > dsmax)) continue;
            idx = i;
            dsmax = ds;
        }
        if (dsmax <= maxDistanceSquared) {
            for (i = first + 1; i < last; ++i) {
                coords[i * 2] = Double.NaN;
                coords[i * 2 + 1] = Double.NaN;
            }
        } else {
            this.dpSimplifySection(first, idx, coords, maxDistanceSquared);
            this.dpSimplifySection(idx, last, coords, maxDistanceSquared);
        }
    }

    private void decimate(Geometry g, LiteCoordinateSequence seq) {
        double[] coords = seq.getXYArray();
        int dim = seq.getDimension();
        int numDoubles = coords.length;
        int readDoubles = 0;
        for (int currentDoubles = 0; currentDoubles < numDoubles; currentDoubles += dim) {
            if (currentDoubles >= dim && currentDoubles < numDoubles - dim) {
                double prevx = coords[readDoubles - dim];
                double currx = coords[currentDoubles];
                double diffx = Math.abs(prevx - currx);
                double prevy = coords[readDoubles - dim + 1];
                double curry = coords[currentDoubles + 1];
                double diffy = Math.abs(prevy - curry);
                if (!(diffx > this.spanx) && !(diffy > this.spany)) continue;
                readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
                continue;
            }
            readDoubles = this.copyCoordinate(coords, dim, readDoubles, currentDoubles);
        }
        if (g instanceof LinearRing && readDoubles < dim * 4) {
            this.decimateRingFully(seq);
        } else if (readDoubles < numDoubles) {
            double[] newCoords = new double[readDoubles];
            System.arraycopy(coords, 0, newCoords, 0, readDoubles);
            seq.setArray(newCoords);
        }
    }

    private int copyCoordinate(double[] coords, int dimension, int readDoubles, int currentDoubles) {
        for (int i = 0; i < dimension; ++i) {
            coords[readDoubles + i] = coords[currentDoubles + i];
        }
        return readDoubles += dimension;
    }

    static {
        int threshold = -1;
        String sthreshold = System.getProperty("org.geotools.decimate.dpThreshold");
        if (sthreshold != null) {
            try {
                threshold = Integer.parseInt(sthreshold);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Invalid value for org.geotools.decimate.dpThreshold, should be a positive integer but is: " + sthreshold);
            }
        }
        DP_THRESHOLD = threshold;
    }
}

