/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;
import org.opengis.filter.capability.FunctionName;

public class EqualIntervalFunction
extends ClassificationFunction {
    public static FunctionName NAME = new FunctionNameImpl("EqualInterval", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class));

    public EqualIntervalFunction() {
        super(NAME);
    }

    private RangedClassifier calculate(SimpleFeatureCollection featureCollection) {
        int classNum = this.getClasses();
        try {
            MinVisitor minVisit = new MinVisitor(this.getParameters().get(0));
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            featureCollection.accepts(minVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            Comparable globalMin = (Comparable)minVisit.getResult().getValue();
            MaxVisitor maxVisit = new MaxVisitor(this.getParameters().get(0));
            featureCollection.accepts(maxVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            Comparable globalMax = (Comparable)maxVisit.getResult().getValue();
            if (globalMin instanceof Number && globalMax instanceof Number) {
                return this.calculateNumerical(classNum, globalMin, globalMax);
            }
            return this.calculateNonNumerical(classNum, featureCollection);
        }
        catch (IllegalFilterException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(SimpleFeatureCollection) failed", e);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "EqualIntervalFunction calculate(SimpleFeatureCollection) failed", e);
            return null;
        }
    }

    private RangedClassifier calculateNumerical(int classNum, Comparable globalMin, Comparable globalMax) {
        if (globalMax.equals(globalMin)) {
            return new RangedClassifier(new Comparable[]{globalMin}, new Comparable[]{globalMax});
        }
        double slotWidth = (((Number)((Object)globalMax)).doubleValue() - ((Number)((Object)globalMin)).doubleValue()) / (double)classNum;
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        for (int i = 0; i < classNum; ++i) {
            localMin[i] = Double.valueOf(((Number)((Object)globalMin)).doubleValue() + (double)i * slotWidth);
            localMax[i] = Double.valueOf(((Number)((Object)globalMax)).doubleValue() - (double)(classNum - i - 1) * slotWidth);
            int decPlaces = this.decimalPlaces(slotWidth);
            if (decPlaces > -1) {
                localMin[i] = Double.valueOf(this.round(((Number)((Object)localMin[i])).doubleValue(), decPlaces));
                localMax[i] = Double.valueOf(this.round(((Number)((Object)localMax[i])).doubleValue(), decPlaces));
            }
            if (i == 0) {
                if (localMin[i].compareTo(((Number)((Object)globalMin)).doubleValue()) < 0) {
                    localMin[i] = Double.valueOf(this.fixRound(((Number)((Object)localMin[i])).doubleValue(), decPlaces, false));
                }
            } else if (i == classNum - 1 && localMax[i].compareTo(((Number)((Object)globalMax)).doubleValue()) > 0) {
                localMax[i] = Double.valueOf(this.fixRound(((Number)((Object)localMax[i])).doubleValue(), decPlaces, true));
            }
            if (i == 0 || localMin[i].equals(localMax[i - 1])) continue;
            localMin[i] = localMax[i - 1];
        }
        return new RangedClassifier(localMin, localMax);
    }

    private RangedClassifier calculateNonNumerical(int classNum, FeatureCollection<?, ?> featureCollection) throws IOException {
        UniqueVisitor uniqueVisit = new UniqueVisitor(this.getParameters().get(0));
        featureCollection.accepts(uniqueVisit, new NullProgressListener());
        List result = uniqueVisit.getResult().toList();
        Collections.sort(result);
        Comparable[] values = result.toArray(new Comparable[result.size()]);
        classNum = Math.min(classNum, values.length);
        Comparable[] localMin = new Comparable[classNum];
        Comparable[] localMax = new Comparable[classNum];
        int binPop = Double.valueOf(Math.ceil((double)values.length / (double)classNum)).intValue();
        int lastBigBin = values.length % classNum;
        lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
        int itemIndex = 0;
        for (int binIndex = 0; binIndex < classNum; ++binIndex) {
            if (binIndex < localMin.length) {
                localMin[binIndex] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
            } else {
                localMin[localMin.length - 1] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
            }
            itemIndex += binPop;
            if (binIndex == classNum - 1) {
                if (binIndex < localMax.length) {
                    localMax[binIndex] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
                } else {
                    localMax[localMax.length - 1] = itemIndex < values.length ? values[itemIndex] : values[values.length - 1];
                }
            } else if (binIndex < localMax.length) {
                localMax[binIndex] = itemIndex + 1 < values.length ? values[itemIndex + 1] : values[values.length - 1];
            } else {
                Comparable comparable = localMax[localMax.length - 1] = itemIndex + 1 < values.length ? values[itemIndex + 1] : values[values.length - 1];
            }
            if (lastBigBin != binIndex) continue;
            --binPop;
        }
        return new RangedClassifier(localMin, localMax);
    }

    @Override
    public RangedClassifier evaluate(Object object) {
        if (!(object instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)object);
    }
}

