/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.CartesianDistanceFilter;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.IsBetweenImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsLessThenOrEqualToImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.BeyondImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.DWithinImpl;
import org.geotools.filter.spatial.DisjointImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.xml.sax.Attributes;

public class FilterSAXParser {
    private static final Logger LOGGER = Logging.getLogger(FilterSAXParser.class);
    private static final int NUM_LIKE_ATTS = 3;
    private Filter curFilter = null;
    private String curState = "uninitialized";
    private short filterType;
    private FilterFactory2 ff;
    private Map attributes = new HashMap();

    public FilterSAXParser() {
        this(CommonFactoryFinder.getFilterFactory2());
    }

    public FilterSAXParser(FilterFactory2 factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory2 factory) {
        this.ff = factory;
    }

    public void start(short filterType) throws IllegalFilterException {
        block27: {
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block26: {
                                        LOGGER.finest("starting filter type " + filterType);
                                        if (filterType != 22 || this.curState.equals("fid")) break block26;
                                        LOGGER.finer("creating the FID filter");
                                        this.curFilter = new FidFilterImpl(Collections.emptySet());
                                        break block27;
                                    }
                                    if (!AbstractFilter.isGeometryDistanceFilter(filterType)) break block28;
                                    switch (filterType) {
                                        case 13: {
                                            this.curFilter = new BeyondImpl(null, null);
                                            break block27;
                                        }
                                        case 24: {
                                            this.curFilter = new DWithinImpl(null, null);
                                            break block27;
                                        }
                                        default: {
                                            throw new IllegalFilterException("Not one of the accepted spatial filter types.");
                                        }
                                    }
                                }
                                if (!AbstractFilter.isGeometryFilter(filterType)) break block29;
                                switch (filterType) {
                                    case 5: {
                                        this.curFilter = new EqualsImpl(null, null);
                                        break block27;
                                    }
                                    case 6: {
                                        this.curFilter = new DisjointImpl(null, null);
                                        break block27;
                                    }
                                    case 24: {
                                        this.curFilter = new DWithinImpl(null, null);
                                        break block27;
                                    }
                                    case 7: {
                                        this.curFilter = new IntersectsImpl(null, null);
                                        break block27;
                                    }
                                    case 9: {
                                        this.curFilter = new CrossesImpl(null, null);
                                        break block27;
                                    }
                                    case 10: {
                                        this.curFilter = new WithinImpl(null, null);
                                        break block27;
                                    }
                                    case 11: {
                                        this.curFilter = new ContainsImpl(null, null);
                                        break block27;
                                    }
                                    case 12: {
                                        this.curFilter = new OverlapsImpl(null, null);
                                        break block27;
                                    }
                                    case 13: {
                                        this.curFilter = new BeyondImpl(null, null);
                                        break block27;
                                    }
                                    case 4: {
                                        this.curFilter = new BBOXImpl(null, null);
                                        break block27;
                                    }
                                    case 8: {
                                        this.curFilter = new TouchesImpl(null, null);
                                        break block27;
                                    }
                                    default: {
                                        throw new IllegalFilterException("Not one of the accepted spatial filter types.");
                                    }
                                }
                            }
                            if (filterType != 19) break block30;
                            this.curFilter = new IsBetweenImpl(null, null, null);
                            break block27;
                        }
                        if (filterType != 21) break block31;
                        this.curFilter = new NullFilterImpl(Expression.NIL);
                        break block27;
                    }
                    if (filterType != 20) break block32;
                    this.curFilter = new LikeFilterImpl();
                    break block27;
                }
                if (!AbstractFilter.isCompareFilter(filterType)) break block33;
                switch (filterType) {
                    case 14: {
                        this.curFilter = new IsEqualsToImpl(null, null);
                        break block27;
                    }
                    case 23: {
                        this.curFilter = new IsNotEqualToImpl(null, null);
                        break block27;
                    }
                    case 16: {
                        this.curFilter = new IsGreaterThanImpl(null, null);
                        break block27;
                    }
                    case 18: {
                        this.curFilter = new IsGreaterThanOrEqualToImpl(null, null);
                        break block27;
                    }
                    case 15: {
                        this.curFilter = new IsLessThenImpl(null, null);
                        break block27;
                    }
                    case 17: {
                        this.curFilter = new IsLessThenOrEqualToImpl(null, null);
                        break block27;
                    }
                    case 19: {
                        this.curFilter = new IsBetweenImpl(null, null, null);
                        break block27;
                    }
                    default: {
                        throw new IllegalFilterException("Must be one of <,<=,==,>,>=,<>");
                    }
                }
            }
            throw new IllegalFilterException("Filter start with invalid type: " + filterType);
        }
        this.curState = FilterSAXParser.setInitialState(filterType);
        this.filterType = filterType;
        this.attributes = new HashMap();
    }

    public void value(String message) throws IllegalFilterException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expression(Expression expression) throws IllegalFilterException {
        if (this.filterType == 19) {
            if (this.curState.equals("attribute")) {
                ((IsBetweenImpl)this.curFilter).setExpression(expression);
                this.curState = "LowerBoundary";
            } else if (this.curState.equals("LowerBoundary")) {
                ((BinaryComparisonAbstract)this.curFilter).setExpression1(expression);
                this.curState = "UpperBoundary";
            } else {
                if (!this.curState.equals("UpperBoundary")) throw new IllegalFilterException("Got expression for Between Filter in illegal state: " + this.curState);
                ((BinaryComparisonAbstract)this.curFilter).setExpression2(expression);
                this.curState = "complete";
            }
        } else if (AbstractFilter.isCompareFilter(this.filterType)) {
            if (this.curState.equals("leftValue")) {
                ((BinaryComparisonAbstract)this.curFilter).setExpression1(expression);
                this.curState = "rightValue";
            } else {
                if (!this.curState.equals("rightValue")) throw new IllegalFilterException("Got expression for Compare Filter in illegal state: " + this.curState);
                ((BinaryComparisonAbstract)this.curFilter).setExpression2(expression);
                this.curState = "complete";
            }
        } else if (this.filterType == 21) {
            if (!this.curState.equals("attribute")) throw new IllegalFilterException("Got expression for Null Filter in illegal state: " + this.curState);
            ((NullFilterImpl)this.curFilter).setExpression(expression);
            this.curState = "complete";
        } else if (AbstractFilter.isGeometryFilter(this.filterType)) {
            if (this.curState.equals("leftValue")) {
                ((BinaryComparisonAbstract)this.curFilter).setExpression1(expression);
                this.curState = "rightValue";
            } else {
                if (!this.curState.equals("rightValue")) throw new IllegalFilterException("Got expression for Geometry Filter in illegal state: " + this.curState);
                ((BinaryComparisonAbstract)this.curFilter).setExpression2(expression);
                this.curState = AbstractFilter.isGeometryDistanceFilter(this.filterType) ? "distance" : "complete";
                LOGGER.finer("expression called on geometry, curState = " + this.curState);
            }
        } else if (this.filterType == 20) {
            if (this.curState.equals("attribute")) {
                ((LikeFilterImpl)this.curFilter).setExpression(expression);
                this.curState = "pattern";
            } else {
                if (!this.curState.equals("pattern")) throw new IllegalFilterException("Got expression for Like Filter in illegal state: " + this.curState);
                if (this.attributes.size() < 3) {
                    throw new IllegalFilterException("Got wrong number of attributes (expecting minimum 3): " + this.attributes.size() + "\n" + this.attributes);
                }
                String wildcard = (String)this.attributes.get("wildCard");
                if (wildcard == null || wildcard.length() != 1) {
                    throw new IllegalFilterException("like filter -- required attribute 'wildCard' missing or not exactly 1 char long.  Capitalization?");
                }
                String singleChar = (String)this.attributes.get("singleChar");
                if (singleChar == null || singleChar.length() != 1) {
                    throw new IllegalFilterException("like filter -- required attribute 'singleChar' missing  or not exactly 1 char long.  Capitalization?");
                }
                String escapeChar = (String)this.attributes.get("escape");
                if (escapeChar == null) {
                    escapeChar = (String)this.attributes.get("escapeChar");
                }
                if (escapeChar == null || escapeChar.length() != 1) {
                    throw new IllegalFilterException("like filter -- required attribute 'escape' missing  or not exactly 1 char long.  Capitalization?");
                }
                LOGGER.fine("escape char is " + escapeChar);
                String matchCase = (String)this.attributes.get("matchCase");
                if (matchCase != null) {
                    ((LikeFilterImpl)this.curFilter).setMatchingCase(Boolean.parseBoolean(matchCase));
                }
                if (!(expression instanceof Literal)) throw new ClassCastException("Pattern must be a literal String");
                Literal literal = (Literal)expression;
                Object value = literal.getValue();
                if (value == null || !(value instanceof String)) {
                    throw new ClassCastException("Pattern Literal must be a string:" + value);
                }
                String pattern = (String)value;
                ((LikeFilterImpl)this.curFilter).setLiteral(pattern);
                ((LikeFilterImpl)this.curFilter).setWildCard(wildcard);
                ((LikeFilterImpl)this.curFilter).setSingleChar(singleChar);
                ((LikeFilterImpl)this.curFilter).setEscape(escapeChar);
                this.curState = "complete";
            }
        }
        LOGGER.finer("current state (end): " + this.curState);
    }

    public Filter create() throws IllegalFilterException {
        if (this.isComplete()) {
            LOGGER.finer("complete called, state = " + this.curState);
            this.curState = "complete";
            return this.curFilter;
        }
        throw new IllegalFilterException("Got to the end state of an incomplete filter, current state is " + this.curState);
    }

    private static String setInitialState(short filterType) throws IllegalFilterException {
        if (filterType == 19 || filterType == 21 || filterType == 20) {
            return "attribute";
        }
        if (filterType == 22) {
            return "fid";
        }
        if (AbstractFilter.isCompareFilter(filterType) || AbstractFilter.isGeometryFilter(filterType)) {
            return "leftValue";
        }
        throw new IllegalFilterException("Filter type: " + filterType + " is not recognized");
    }

    public void setDistance(String distance, String units) throws IllegalFilterException {
        LOGGER.finer("set distance called, current state is " + this.curState);
        if (this.curState.equals("distance")) {
            try {
                double distDouble = Double.parseDouble(distance);
                ((CartesianDistanceFilter)this.curFilter).setDistance(distDouble);
                this.curState = "complete";
            }
            catch (NumberFormatException nfe) {
                throw new IllegalFilterException("could not parse distance: " + distance + " to a double");
            }
        } else {
            throw new IllegalFilterException("Got distance for Geometry Distance Filter in illegal state: " + this.curState + ", geometry and property should be set first");
        }
    }

    public void setAttributes(Attributes atts) {
        LOGGER.finer("got attribute: " + atts.getLocalName(0) + ", " + atts.getValue(0));
        LOGGER.finer("current state: " + this.curState);
        if (this.curState.equals("fid")) {
            LOGGER.finer("is a fid");
            ((FidFilterImpl)this.curFilter).addFid(atts.getValue(0));
            LOGGER.finer("added fid");
        } else {
            for (int i = 0; i < atts.getLength(); ++i) {
                this.attributes.put(atts.getLocalName(i), atts.getValue(i));
            }
        }
    }

    private boolean isComplete() {
        return this.curState.equals("complete") || this.curState.equals("fid");
    }
}

