/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.FactoryRegistryException;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectingFeatureIterator
implements SimpleFeatureIterator {
    SimpleFeatureIterator delegate;
    CoordinateReferenceSystem target;
    SimpleFeatureType schema;
    GeometryCoordinateSequenceTransformer tx;

    public ReprojectingFeatureIterator(SimpleFeatureIterator delegate, MathTransform transform, SimpleFeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.schema = schema;
        this.tx = transformer;
        this.tx.setMathTransform((MathTransform2D)transform);
    }

    public ReprojectingFeatureIterator(SimpleFeatureIterator delegate, CoordinateReferenceSystem source, CoordinateReferenceSystem target, SimpleFeatureType schema, GeometryCoordinateSequenceTransformer transformer) throws OperationNotFoundException, FactoryRegistryException, FactoryException {
        this.delegate = delegate;
        this.target = target;
        this.schema = schema;
        this.tx = transformer;
        MathTransform transform = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(source, target).getMathTransform();
        this.tx.setMathTransform(transform);
    }

    public SimpleFeatureIterator getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public SimpleFeature next() {
        SimpleFeature feature = (SimpleFeature)this.delegate.next();
        try {
            return this.reproject(feature);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    SimpleFeature reproject(SimpleFeature feature) throws IOException {
        List<Object> attributes = feature.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            Object object = attributes.get(i);
            if (!(object instanceof Geometry)) continue;
            Geometry geometry = (Geometry)object;
            try {
                attributes.set(i, this.tx.transform(geometry));
                continue;
            }
            catch (TransformException e) {
                String msg = "Error occured transforming " + geometry.toString();
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        try {
            return SimpleFeatureBuilder.build(this.schema, attributes, feature.getID());
        }
        catch (IllegalAttributeException e) {
            String msg = "Error creating reprojeced feature";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

