/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.io.GridCoverageResponse;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public class DefaultGridCoverageResponse
implements GridCoverageResponse {
    private GridCoverage gridCoverage;
    private DateRange temporalExtent;
    private NumberRange<Double> verticalExtent;

    public DefaultGridCoverageResponse(GridCoverage gridCoverage, DateRange temporalExtent, NumberRange<Double> verticalExtent) {
        this.temporalExtent = temporalExtent;
        this.verticalExtent = verticalExtent;
        this.gridCoverage = gridCoverage;
    }

    @Override
    public DateRange getTemporalExtent() {
        return this.temporalExtent;
    }

    @Override
    public NumberRange<Double> getVerticalExtent() {
        return this.verticalExtent;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    @Override
    public Envelope getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    @Override
    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    @Override
    public Set<Record> evaluate(DirectPosition p, Collection<String> list) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(p, list);
    }

    @Override
    public Object evaluate(DirectPosition point) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.gridCoverage.evaluate(point);
    }

    @Override
    public boolean[] evaluate(DirectPosition point, boolean[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public byte[] evaluate(DirectPosition point, byte[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public int[] evaluate(DirectPosition point, int[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public float[] evaluate(DirectPosition point, float[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public double[] evaluate(DirectPosition point, double[] destination) throws PointOutsideCoverageException, CannotEvaluateException, ArrayIndexOutOfBoundsException {
        return this.gridCoverage.evaluate(point, destination);
    }

    @Override
    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    @Override
    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    @Override
    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    @Override
    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    @Override
    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    @Override
    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    @Override
    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    @Override
    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    @Override
    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    @Override
    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    @Override
    public GridCoverage2D getGridCoverage2D() {
        return (GridCoverage2D)this.gridCoverage;
    }
}

