/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.ComparableUnit;
import tec.units.indriya.format.SimpleUnitFormat;
import tec.units.indriya.function.AddConverter;
import tec.units.indriya.function.MultiplyConverter;
import tec.units.indriya.function.RationalConverter;
import tec.units.indriya.quantity.QuantityDimension;
import tec.units.indriya.spi.DimensionalModel;
import tec.units.indriya.unit.AlternateUnit;
import tec.units.indriya.unit.AnnotatedUnit;
import tec.units.indriya.unit.CompoundUnit;
import tec.units.indriya.unit.ProductUnit;
import tec.units.indriya.unit.TransformedUnit;

public abstract class AbstractUnit<Q extends Quantity<Q>>
implements ComparableUnit<Q> {
    private static final long serialVersionUID = -4344589505537030204L;
    public static final Unit<Dimensionless> ONE = new ProductUnit<Dimensionless>();
    protected String name;
    private String symbol;
    protected static final Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected AbstractUnit() {
    }

    protected Type getActualType() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments()[0].getClass().getGenericInterfaces()[0];
    }

    @Override
    public boolean isSystemUnit() {
        Unit<Q> si = this.toSystemUnit();
        return this == si || this.equals(si);
    }

    protected abstract Unit<Q> toSystemUnit();

    public abstract UnitConverter getSystemConverter();

    public Unit<Q> annotate(String annotation) {
        return new AnnotatedUnit(this, annotation);
    }

    public final Unit<Q> compound(Unit<Q> that) {
        return new CompoundUnit<Q>(this, that);
    }

    public static Unit<?> parse(CharSequence charSequence) {
        return SimpleUnitFormat.getInstance().parse(charSequence);
    }

    public String toString() {
        return SimpleUnitFormat.getInstance().format(this);
    }

    public final Unit<Q> getSystemUnit() {
        return this.toSystemUnit();
    }

    public final boolean isCompatible(Unit<?> that) {
        return this.internalIsCompatible(that, true);
    }

    public final <T extends Quantity<T>> AbstractUnit<T> asType(Class<T> type) {
        Dimension typeDimension = QuantityDimension.of(type);
        if (typeDimension != null && !typeDimension.equals(this.getDimension())) {
            throw new ClassCastException("The unit: " + this + " is not compatible with quantities of type " + type);
        }
        return this;
    }

    public abstract Map<? extends Unit<?>, Integer> getBaseUnits();

    public abstract Dimension getDimension();

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    protected void setSymbol(String s) {
        this.symbol = s;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        return this.internalGetConverterTo(that, true);
    }

    public final UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (!this.isCompatible(that)) {
            throw new IncommensurableException(this + " is not compatible with " + that);
        }
        AbstractUnit thatAbstr = (AbstractUnit)that;
        DimensionalModel model = DimensionalModel.current();
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        UnitConverter thisToDimension = model.getDimensionalTransform(thisSystemUnit.getDimension()).concatenate(this.getSystemConverter());
        Unit<Q> thatSystemUnit = thatAbstr.getSystemUnit();
        UnitConverter thatToDimension = model.getDimensionalTransform(thatSystemUnit.getDimension()).concatenate(thatAbstr.getSystemConverter());
        return thatToDimension.inverse().concatenate(thisToDimension);
    }

    public final Unit<Q> alternate(String symbol) {
        return new AlternateUnit(this, symbol);
    }

    public final Unit<Q> transform(UnitConverter operation) {
        Unit<Q> systemUnit = this.getSystemUnit();
        UnitConverter cvtr = this.isSystemUnit() ? this.getSystemConverter().concatenate(operation) : operation;
        if (cvtr.equals(AbstractConverter.IDENTITY)) {
            return systemUnit;
        }
        return new TransformedUnit<Q>(null, this, systemUnit, cvtr);
    }

    public final Unit<Q> shift(double offset) {
        if (offset == 0.0) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    public final Unit<Q> multiply(double factor) {
        if (factor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(factor)) {
            return this.transform(new RationalConverter(BigInteger.valueOf((long)factor), BigInteger.ONE));
        }
        return this.transform(new MultiplyConverter(factor));
    }

    private final boolean internalIsCompatible(Unit<?> that, boolean checkEquals) {
        Dimension thatDimension;
        if (checkEquals ? this == that || this.equals(that) : this == that) {
            return true;
        }
        if (!(that instanceof AbstractUnit)) {
            return false;
        }
        Dimension thisDimension = this.getDimension();
        if (thisDimension.equals(thatDimension = that.getDimension())) {
            return true;
        }
        DimensionalModel model = DimensionalModel.current();
        return model.getFundamentalDimension(thisDimension).equals(model.getFundamentalDimension(thatDimension));
    }

    private final UnitConverter internalGetConverterTo(Unit<Q> that, boolean useEquals) throws UnconvertibleException {
        Unit thatSystemUnit;
        if (useEquals ? this == that || this.equals(that) : this == that) {
            return AbstractConverter.IDENTITY;
        }
        Unit<Q> thisSystemUnit = this.getSystemUnit();
        if (!thisSystemUnit.equals((Object)(thatSystemUnit = that.getSystemUnit()))) {
            try {
                return this.getConverterToAny(that);
            }
            catch (IncommensurableException e) {
                throw new UnconvertibleException((Throwable)e);
            }
        }
        UnitConverter thisToSI = this.getSystemConverter();
        UnitConverter thatToSI = that.getConverterTo(thatSystemUnit);
        return thatToSI.inverse().concatenate(thisToSI);
    }

    private static boolean isLongValue(double value) {
        return !(value < -9.223372036854776E18) && !(value > 9.223372036854776E18) && Math.floor(value) == value;
    }

    public final Unit<?> multiply(Unit<?> that) {
        if (that instanceof AbstractUnit) {
            return this.multiply((AbstractUnit)that);
        }
        return ProductUnit.ofProduct(this, that);
    }

    protected final Unit<?> multiply(AbstractUnit<?> that) {
        if (this.equals(ONE)) {
            return that;
        }
        if (that.equals(ONE)) {
            return this;
        }
        return ProductUnit.ofProduct(this, that);
    }

    public final Unit<?> inverse() {
        if (this.equals(ONE)) {
            return this;
        }
        return ProductUnit.ofQuotient(ONE, this);
    }

    public final Unit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(divisor)) {
            return this.transform(new RationalConverter(BigInteger.ONE, BigInteger.valueOf((long)divisor)));
        }
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final Unit<?> divide(Unit<?> that) {
        return this.multiply(that.inverse());
    }

    protected final Unit<?> divide(AbstractUnit<?> that) {
        return this.multiply(that.inverse());
    }

    public final Unit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.ofRoot(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    @Override
    public int compareTo(Unit<Q> that) {
        if (this.name != null && this.getSymbol() != null) {
            return this.name.compareTo(that.getName()) + this.getSymbol().compareTo(that.getSymbol());
        }
        if (this.name == null) {
            if (this.getSymbol() != null && that.getSymbol() != null) {
                return this.getSymbol().compareTo(that.getSymbol());
            }
            return -1;
        }
        if (this.getSymbol() == null) {
            if (this.name != null) {
                return this.name.compareTo(that.getName());
            }
            return -1;
        }
        UnitConverter conv = this.getConverterTo(that);
        if (conv instanceof AbstractConverter) {
            return ((AbstractConverter)conv).compareTo(that.getConverterTo((Unit)this));
        }
        return -1;
    }

    @Override
    public boolean isEquivalentOf(Unit<Q> that) {
        if (this.compareTo(that) == 0) {
            return true;
        }
        return this.getConverterTo(that).equals(that.getConverterTo((Unit)this));
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected static final class Equalizer {
        protected Equalizer() {
        }

        public static boolean areEqual(AbstractUnit u1, AbstractUnit u2) {
            return u1 == u2;
        }
    }
}

