/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.util;

import java.util.Comparator;
import org.geotools.util.Range;
import org.geotools.util.Utilities;

public class NumberRangeComparator
implements Comparator<Range<? extends Number>> {
    @Override
    public int compare(Range<? extends Number> firstRange, Range<? extends Number> secondRange) {
        Utilities.ensureNonNull((String)"firstRange", firstRange);
        Utilities.ensureNonNull((String)"secondRange", secondRange);
        Number firstRangeMin = (Number)((Object)firstRange.getMinValue());
        Number firstRangeMax = (Number)((Object)firstRange.getMaxValue());
        Number secondRangeMin = (Number)((Object)secondRange.getMinValue());
        Number secondRangeMax = (Number)((Object)secondRange.getMaxValue());
        return NumberRangeComparator.doubleCompare(firstRangeMin.doubleValue(), firstRangeMax.doubleValue(), secondRangeMin.doubleValue(), secondRangeMax.doubleValue());
    }

    public static int doubleCompare(double firstRangeMin, double firstRangeMax, double secondRangeMin, double secondRangeMax) {
        if (firstRangeMin == secondRangeMin && firstRangeMax == secondRangeMax) {
            return 0;
        }
        if (firstRangeMin == secondRangeMin) {
            if (firstRangeMax > secondRangeMax) {
                return 1;
            }
            return -1;
        }
        if (firstRangeMin < secondRangeMin) {
            if (firstRangeMax > secondRangeMax) {
                return -3;
            }
            if (firstRangeMax < secondRangeMax) {
                return -4;
            }
            return -2;
        }
        if (firstRangeMax < secondRangeMax) {
            return 3;
        }
        if (firstRangeMax > secondRangeMax) {
            return 4;
        }
        return 2;
    }
}

