/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.IndexedShapefileFeatureWriter;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.ShapefileFeatureSource;
import org.geotools.data.shapefile.ShapefileFeatureWriter;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

class ShapefileFeatureStore
extends ContentFeatureStore {
    ShapefileFeatureSource delegate;

    public ShapefileFeatureStore(ContentEntry entry, ShpFiles files) {
        super(entry, Query.ALL);
        this.delegate = new ShapefileFeatureSource(entry, files);
        this.hints = this.delegate.getSupportedHints();
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        Filter filter;
        if (flags == 0) {
            throw new IllegalArgumentException("no write flags set");
        }
        ShapefileFeatureReader reader = (ShapefileFeatureReader)this.delegate.getReaderInternal(Query.ALL);
        ShapefileDataStore ds = this.getDataStore();
        ShapefileFeatureWriter writer = ds.indexManager.hasFidIndex(false) || ds.isFidIndexed() && ds.indexManager.hasFidIndex(true) ? new IndexedShapefileFeatureWriter(ds.indexManager, reader, ds.getCharset(), ds.getTimeZone()) : new ShapefileFeatureWriter(this.delegate.shpFiles, reader, ds.getCharset(), ds.getTimeZone());
        writer.setMaxShpSize(this.getDataStore().getMaxShpSize());
        writer.setMaxDbfSize(this.getDataStore().getMaxDbfSize());
        if ((flags | 1) == 1) {
            while (writer.hasNext()) {
                writer.next();
            }
        }
        if ((filter = query.getFilter()) != null && !Filter.INCLUDE.equals(filter)) {
            return new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    @Override
    public ShapefileDataStore getDataStore() {
        return this.delegate.getDataStore();
    }

    @Override
    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    @Override
    public ResourceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.delegate.getQueryCapabilities();
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    @Override
    public ContentEntry getEntry() {
        return this.delegate.getEntry();
    }

    @Override
    public Name getName() {
        return this.delegate.getName();
    }

    @Override
    public ContentState getState() {
        return this.delegate.getState();
    }

    @Override
    public void setTransaction(Transaction transaction) {
        super.setTransaction(transaction);
        if (this.delegate.getTransaction() != transaction) {
            this.delegate.setTransaction(transaction);
        }
    }

    @Override
    protected boolean canFilter() {
        return this.delegate.canFilter();
    }

    @Override
    protected boolean canRetype() {
        return this.delegate.canRetype();
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return this.delegate.handleVisitor(query, visitor);
    }
}

