/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd.impl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.geotools.xs.facets.Whitespace;
import org.geotools.xsd.AttributeInstance;
import org.geotools.xsd.Binding;
import org.geotools.xsd.ComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Node;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.SimpleBinding;
import org.geotools.xsd.impl.BindingWalker;
import org.geotools.xsd.impl.InstanceBinding;
import org.geotools.xsd.impl.InstanceComponentImpl;
import org.geotools.xsd.impl.ParserHandler;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class ParseExecutor
implements BindingWalker.Visitor {
    private InstanceComponent instance;
    private Node node;
    private MutablePicoContainer context;
    private ParserHandler parser;
    private Object value;
    private Object result;

    public ParseExecutor(InstanceComponent instance, Node node, MutablePicoContainer context, ParserHandler parser) {
        this.instance = instance;
        this.node = node;
        this.context = context;
        this.parser = parser;
    }

    @Override
    public void visit(Binding binding) {
        if (!(binding instanceof InstanceBinding)) {
            Class<?> bindingClass = binding.getClass();
            QName bindingTarget = binding.getTarget();
            if ((binding = (Binding)this.context.getComponentInstanceOfType(binding.getClass())) == null) {
                binding = this.parser.getBindingLoader().loadBinding(bindingTarget, (PicoContainer)this.context);
                if (binding == null) {
                    binding = this.parser.getBindingLoader().loadBinding(bindingTarget, bindingClass, (PicoContainer)this.context);
                }
                if (binding.getClass() != bindingClass) {
                    throw new IllegalStateException("Reloaded binding resulted in different type, from " + bindingClass + " to " + binding.getClass());
                }
            }
        }
        try {
            if (this.result == null) {
                XSDTypeDefinition type = null;
                type = Schemas.nameMatches(this.instance.getDeclaration(), binding.getTarget()) ? this.instance.getTypeDefinition() : Schemas.getBaseTypeDefinition(this.instance.getTypeDefinition(), binding.getTarget());
                if (this.value == null) {
                    this.value = this.preParse(this.instance);
                    this.result = type != null && (type instanceof XSDSimpleTypeDefinition || ((XSDComplexTypeDefinition)type).isMixed()) ? this.value : (this.value != null && this.value instanceof String ? ("".equals(((String)this.value).trim()) ? null : this.value) : this.value);
                }
            }
            this.result = binding instanceof SimpleBinding ? ((SimpleBinding)binding).parse(this.instance, this.result) : ((ComplexBinding)binding).parse((ElementInstance)this.instance, this.node, this.result);
            if (this.result != null) {
                this.value = this.result;
            }
        }
        catch (Throwable t) {
            String msg = "Parsing failed for " + this.instance.getName() + ": " + t.toString();
            throw new RuntimeException(msg, t);
        }
    }

    public Object getValue() {
        return this.value;
    }

    protected Object preParse(InstanceComponent instance) {
        XSDSimpleTypeDefinition type = null;
        if (instance.getTypeDefinition() instanceof XSDSimpleTypeDefinition) {
            type = (XSDSimpleTypeDefinition)instance.getTypeDefinition();
        } else {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)instance.getTypeDefinition();
            if (complexType.getContentType() instanceof XSDSimpleTypeDefinition) {
                type = (XSDSimpleTypeDefinition)complexType.getContentType();
            }
        }
        String text = instance.getText();
        if (type != null) {
            if (type.getVariety() == XSDVariety.LIST_LITERAL) {
                text = Whitespace.COLLAPSE.preparse(text);
                String[] list = text.split(" +");
                final XSDSimpleTypeDefinition itemType = type.getItemTypeDefinition();
                ArrayList<Object> parsed = new ArrayList<Object>();
                final XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                element.setTypeDefinition((XSDTypeDefinition)itemType);
                if (instance.getName() != null) {
                    element.setName(instance.getName());
                }
                if (instance.getNamespace() != null) {
                    element.setTargetNamespace(instance.getNamespace());
                }
                InstanceComponentImpl theInstance = new InstanceComponentImpl(){

                    @Override
                    public XSDTypeDefinition getTypeDefinition() {
                        return itemType;
                    }

                    @Override
                    public XSDNamedComponent getDeclaration() {
                        return element;
                    }
                };
                for (int i = 0; i < list.length; ++i) {
                    theInstance.setText(list[i]);
                    ParseExecutor executor = new ParseExecutor(theInstance, null, this.context, this.parser);
                    this.parser.getBindingWalker().walk((XSDFeature)element, executor, this.context);
                    parsed.add(executor.getValue());
                }
                return parsed;
            }
            if (type.getVariety() == XSDVariety.UNION_LITERAL) {
                return text;
            }
            for (XSDFacet facet : type.getFacets()) {
                if (!(facet instanceof XSDWhiteSpaceFacet) || this.parser.isCDATA()) continue;
                XSDWhiteSpaceFacet whitespace = (XSDWhiteSpaceFacet)facet;
                if (whitespace.getValue() == XSDWhiteSpace.REPLACE_LITERAL) {
                    text = Whitespace.REPLACE.preparse(text);
                }
                if (whitespace.getValue() == XSDWhiteSpace.COLLAPSE_LITERAL) {
                    text = Whitespace.COLLAPSE.preparse(text);
                }
                if (whitespace.getValue() != XSDWhiteSpace.PRESERVE_LITERAL || instance instanceof AttributeInstance) continue;
                text = text.trim();
            }
            return text;
        }
        if (instance.getTypeDefinition() instanceof XSDComplexTypeDefinition && ((XSDComplexTypeDefinition)instance.getTypeDefinition()).isMixed() && !this.parser.isCDATA()) {
            text = Whitespace.COLLAPSE.preparse(text);
        }
        if (!this.parser.isCDATA()) {
            text = Whitespace.COLLAPSE.preparse(text);
        }
        return text;
    }

    protected Object parseFacets(InstanceComponent instance) {
        String value = instance.getText();
        for (XSDTypeDefinition type = instance.getTypeDefinition(); type != null; type = type.getBaseType()) {
            if (type instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)type;
                EList facets = simpleType.getFacets();
                for (XSDFacet facet : facets) {
                    Whitespace whitespace;
                    if (!"whiteSpace".equals(facet.getFacetName()) || (whitespace = Whitespace.valueOf(facet.getLexicalValue())) == null) continue;
                    value = whitespace.preparse(value);
                }
            }
            if (type.equals(type.getBaseType())) break;
        }
        return value;
    }
}

