/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.IOException;
import java.lang.reflect.Array;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.math.XMath;
import org.geotools.referencing.wkt.Adapter;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.GeoToolsCRSUnitFormat;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.Arguments;
import org.geotools.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import si.uom.SI;
import tec.uom.se.AbstractUnit;

public class Formatter {
    private static final Class<? extends IdentifiedObject>[] AUTHORITY_EXCLUDE = new Class[]{CoordinateSystemAxis.class};
    private static final String NUMBER_COLOR = "\u001b[33m";
    private static final String INTEGER_COLOR = "\u001b[33m";
    private static final String UNIT_COLOR = "\u001b[33m";
    private static final String AXIS_COLOR = "\u001b[36m";
    private static final String CODELIST_COLOR = "\u001b[36m";
    private static final String PARAMETER_COLOR = "\u001b[32m";
    private static final String METHOD_COLOR = "\u001b[32m";
    private static final String DATUM_COLOR = "\u001b[32m";
    private static final String ERROR_COLOR = "\u001b[41m";
    private final Symbols symbols;
    private Citation authority = Citations.OGC;
    boolean colorEnabled = false;
    private Unit<Length> linearUnit;
    private Unit<Angle> angularUnit;
    private final NumberFormat numberFormat;
    private UnitFormat unitFormat = GeoToolsCRSUnitFormat.getInstance(Citations.EPSG);
    private final FieldPosition dummy = new FieldPosition(0);
    StringBuffer buffer;
    int bufferBase;
    final int indentation;
    private int margin;
    private boolean lineChanged;
    private boolean invalidWKT;
    private Class<?> unformattable;
    String warning;

    public Citation getAuthority() {
        return this.authority;
    }

    public void setAuthority(Citation authority) {
        this.authority = authority;
        this.unitFormat = GeoToolsCRSUnitFormat.getInstance(authority);
    }

    public Formatter() {
        this(Symbols.DEFAULT, 0);
    }

    public Formatter(Symbols symbols) {
        this(symbols, 0);
    }

    public Formatter(Symbols symbols, int indentation) {
        this.symbols = symbols;
        this.indentation = indentation;
        if (symbols == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)"symbols"));
        }
        if (indentation < 0) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"indentation", (Object)indentation));
        }
        this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        this.buffer = new StringBuffer();
    }

    Formatter(Symbols symbols, NumberFormat numberFormat) {
        this.symbols = symbols;
        this.indentation = Formattable.getIndentation();
        this.numberFormat = numberFormat;
    }

    private void setColor(String color) {
        if (this.colorEnabled) {
            this.buffer.append(color);
        }
    }

    private void resetColor() {
        if (this.colorEnabled) {
            this.buffer.append("\u001b[39m");
        }
    }

    private static String getNameColor(IdentifiedObject object) {
        if (object instanceof Datum) {
            return "\u001b[32m";
        }
        if (object instanceof OperationMethod) {
            return "\u001b[32m";
        }
        if (object instanceof CoordinateSystemAxis) {
            return "\u001b[36m";
        }
        return null;
    }

    private void appendSeparator(boolean newLine) {
        char c;
        int length = this.buffer.length();
        do {
            if (length == this.bufferBase) {
                return;
            }
            if ((c = this.buffer.charAt(--length)) != this.symbols.open && c != this.symbols.openArray) continue;
            return;
        } while (Character.isWhitespace(c) || c == this.symbols.space);
        this.buffer.append(this.symbols.separator).append(this.symbols.space);
        if (newLine && this.indentation != 0) {
            this.buffer.append(System.getProperty("line.separator", "\n")).append(Utilities.spaces((int)this.margin));
            this.lineChanged = true;
        }
    }

    public void append(Formattable formattable) {
        Citation authority;
        IdentifiedObject info;
        this.appendSeparator(true);
        int base = this.buffer.length();
        this.buffer.append(this.symbols.open);
        IdentifiedObject identifiedObject = info = formattable instanceof IdentifiedObject ? (IdentifiedObject)formattable : null;
        if (info != null) {
            String c = Formatter.getNameColor(info);
            if (c != null) {
                this.setColor(c);
            }
            this.buffer.append(this.symbols.quote).append(this.getName(info)).append(this.symbols.quote);
            if (c != null) {
                this.resetColor();
            }
        }
        this.indent(1);
        this.lineChanged = false;
        String keyword = formattable.formatWKT(this);
        if (this.colorEnabled && this.invalidWKT) {
            this.invalidWKT = false;
            this.buffer.insert(base, "\u001b[41m\u001b[49m");
            base += ERROR_COLOR.length();
        }
        this.buffer.insert(base, keyword);
        Identifier identifier = this.getIdentifier(info);
        if (identifier != null && Formatter.authorityAllowed(info) && (authority = identifier.getAuthority()) != null) {
            InternationalString inter = authority.getTitle();
            String title = inter != null ? inter.toString(this.symbols.locale) : null;
            for (InternationalString alt : authority.getAlternateTitles()) {
                String candidate;
                if (alt == null || (candidate = alt.toString(this.symbols.locale)) == null || title != null && candidate.length() >= title.length()) continue;
                title = candidate;
            }
            if (title != null) {
                this.appendSeparator(this.lineChanged);
                this.buffer.append("AUTHORITY").append(this.symbols.open).append(this.symbols.quote).append(title).append(this.symbols.quote);
                String code = identifier.getCode();
                if (code != null) {
                    this.buffer.append(this.symbols.separator).append(this.symbols.quote).append(code).append(this.symbols.quote);
                }
                this.buffer.append(this.symbols.close);
            }
        }
        this.buffer.append(this.symbols.close);
        this.lineChanged = true;
        this.indent(-1);
    }

    public void append(IdentifiedObject info) {
        if (info instanceof Formattable) {
            this.append((Formattable)info);
        } else {
            this.append(new Adapter(info));
        }
    }

    public void append(MathTransform transform) {
        if (transform instanceof Formattable) {
            this.append((Formattable)transform);
        } else {
            this.append(new Adapter(transform));
        }
    }

    public void append(CodeList code) {
        if (code != null) {
            boolean needQuotes;
            this.appendSeparator(false);
            this.setColor("\u001b[36m");
            String name = code.name();
            boolean bl = needQuotes = name.indexOf(32) >= 0;
            if (needQuotes) {
                this.buffer.append(this.symbols.quote);
            }
            this.buffer.append(name);
            if (needQuotes) {
                this.buffer.append(this.symbols.quote);
                this.setInvalidWKT(code.getClass());
            }
            this.resetColor();
        }
    }

    public void append(GeneralParameterValue parameter) {
        if (parameter instanceof ParameterValueGroup) {
            for (GeneralParameterValue param : ((ParameterValueGroup)parameter).values()) {
                this.append(param);
            }
        }
        if (parameter instanceof ParameterValue) {
            ParameterValue param = (ParameterValue)parameter;
            ParameterDescriptor descriptor = param.getDescriptor();
            Unit<Length> valueUnit = descriptor.getUnit();
            Unit<Length> unit = valueUnit;
            if (unit != null && !AbstractUnit.ONE.equals(unit)) {
                if (this.linearUnit != null && unit.isCompatible(this.linearUnit)) {
                    unit = this.linearUnit;
                } else if (this.angularUnit != null && unit.isCompatible(this.angularUnit)) {
                    unit = this.angularUnit;
                }
            }
            this.appendSeparator(true);
            int start = this.buffer.length();
            this.buffer.append("PARAMETER");
            int stop = this.buffer.length();
            this.buffer.append(this.symbols.open);
            this.setColor("\u001b[32m");
            this.buffer.append(this.symbols.quote).append(this.getName((IdentifiedObject)descriptor)).append(this.symbols.quote);
            this.resetColor();
            this.buffer.append(this.symbols.separator).append(this.symbols.space);
            if (unit != null) {
                double value;
                try {
                    value = param.doubleValue(unit);
                }
                catch (IllegalStateException exception) {
                    if (this.colorEnabled) {
                        this.buffer.insert(stop, "\u001b[49m").insert(start, ERROR_COLOR);
                    }
                    this.warning = exception.getLocalizedMessage();
                    value = Double.NaN;
                }
                if (!unit.equals(valueUnit)) {
                    value = XMath.trimDecimalFractionDigits((double)value, (int)4, (int)9);
                }
                this.format(value);
            } else {
                this.appendObject(param.getValue());
            }
            this.buffer.append(this.symbols.close);
        }
    }

    private void appendObject(Object value) {
        if (value == null) {
            this.buffer.append("null");
            return;
        }
        if (value.getClass().isArray()) {
            this.buffer.append(this.symbols.openArray);
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    this.buffer.append(this.symbols.separator).append(this.symbols.space);
                }
                this.appendObject(Array.get(value, i));
            }
            this.buffer.append(this.symbols.closeArray);
            return;
        }
        if (value instanceof Number) {
            this.format((Number)value);
        } else {
            this.buffer.append(this.symbols.quote).append(value).append(this.symbols.quote);
        }
    }

    public void append(int number) {
        this.appendSeparator(false);
        this.format(number);
    }

    public void append(double number) {
        this.appendSeparator(false);
        this.format(number);
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            try {
                this.appendSeparator(this.lineChanged);
                this.buffer.append("UNIT").append(this.symbols.open);
                this.setColor("\u001b[33m");
                this.buffer.append(this.symbols.quote);
                this.unitFormat.format(unit, (Appendable)this.buffer);
                this.buffer.append(this.symbols.quote);
                this.resetColor();
                Unit base = null;
                if (SI.METRE.isCompatible(unit)) {
                    base = SI.METRE;
                } else if (SI.SECOND.isCompatible(unit)) {
                    base = SI.SECOND;
                } else if (SI.RADIAN.isCompatible(unit) && !AbstractUnit.ONE.equals(unit)) {
                    base = SI.RADIAN;
                }
                if (base != null) {
                    this.append(unit.getConverterToAny(base).convert(1.0));
                }
            }
            catch (IOException | IncommensurableException | UnconvertibleException e) {
                throw new IllegalArgumentException("The provided unit is not compatible", e);
            }
            this.buffer.append(this.symbols.close);
        }
    }

    public void append(String text) {
        this.appendSeparator(false);
        this.buffer.append(this.symbols.quote).append(text).append(this.symbols.quote);
    }

    private void format(Number number) {
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.format(number.intValue());
        } else {
            this.format(number.doubleValue());
        }
    }

    private void format(int number) {
        this.setColor("\u001b[33m");
        int fraction = this.numberFormat.getMinimumFractionDigits();
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.numberFormat.setMinimumFractionDigits(fraction);
        this.resetColor();
    }

    private void format(double number) {
        this.setColor("\u001b[33m");
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.resetColor();
    }

    private void indent(int amount) {
        this.margin = Math.max(0, this.margin + this.indentation * amount);
    }

    private static boolean authorityAllowed(IdentifiedObject info) {
        for (int i = 0; i < AUTHORITY_EXCLUDE.length; ++i) {
            if (!AUTHORITY_EXCLUDE[i].isInstance(info)) continue;
            return false;
        }
        return true;
    }

    public Identifier getIdentifier(IdentifiedObject info) {
        Set identifiers;
        Identifier first = null;
        if (info != null && (identifiers = info.getIdentifiers()) != null) {
            for (Identifier id : identifiers) {
                if (this.authorityMatches(id.getAuthority())) {
                    return id;
                }
                if (first != null) continue;
                first = id;
            }
        }
        return first;
    }

    private boolean authorityMatches(Citation citation) {
        if (this.authority == citation) {
            return true;
        }
        return citation != null && this.authority.getTitle().toString(null).equalsIgnoreCase(citation.getTitle().toString(null));
    }

    public String getName(IdentifiedObject info) {
        Collection aliases;
        ReferenceIdentifier name = info.getName();
        if (!this.authorityMatches(name.getAuthority()) && (aliases = info.getAlias()) != null) {
            for (GenericName alias : aliases) {
                Identifier candidate;
                if (!(alias instanceof Identifier) || !this.authorityMatches((candidate = (Identifier)alias).getAuthority())) continue;
                return candidate.getCode();
            }
            String title = this.authority.getTitle().toString(null);
            for (GenericName alias : aliases) {
                GenericName scope = alias.scope().name();
                if (scope == null || !title.equalsIgnoreCase(scope.toString())) continue;
                return alias.tip().toString();
            }
        }
        return name.getCode();
    }

    public Unit<Length> getLinearUnit() {
        return this.linearUnit;
    }

    public void setLinearUnit(Unit<Length> unit) {
        if (unit != null && !SI.METRE.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format((int)113, unit));
        }
        this.linearUnit = unit;
    }

    public Unit<Angle> getAngularUnit() {
        return this.angularUnit;
    }

    public void setAngularUnit(Unit<Angle> unit) {
        if (unit != null && (!SI.RADIAN.isCompatible(unit) || AbstractUnit.ONE.equals(unit))) {
            throw new IllegalArgumentException(Errors.format((int)107, unit));
        }
        this.angularUnit = unit;
    }

    public boolean isInvalidWKT() {
        return this.unformattable != null || this.buffer != null && this.buffer.length() == 0;
    }

    final Class getUnformattableClass() {
        return this.unformattable;
    }

    public void setInvalidWKT(Class<?> unformattable) {
        this.unformattable = unformattable;
        this.invalidWKT = true;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.linearUnit = null;
        this.angularUnit = null;
        this.unformattable = null;
        this.warning = null;
        this.invalidWKT = false;
        this.lineChanged = false;
        this.margin = 0;
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        int indentation = arguments.getRequiredInteger("Indentation");
        arguments.getRemainingArguments(0);
        Formattable.setIndentation(indentation);
    }
}

