/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotools.referencing.factory.AllAuthoritiesFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.HTTP_AuthorityFactory;
import org.geotools.referencing.factory.URI_Parser;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public abstract class Abstract_URI_AuthorityFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private final AllAuthoritiesFactory factory;
    private final SortedMap<Version, AuthorityFactory> byVersions = new TreeMap<Version, AuthorityFactory>();
    private transient URI_Parser last;

    public Abstract_URI_AuthorityFactory(String hintsAuthority) {
        this((Hints)null, hintsAuthority);
    }

    public Abstract_URI_AuthorityFactory(Hints userHints, String hintsAuthority) {
        this(HTTP_AuthorityFactory.getFactory(userHints, hintsAuthority));
    }

    public Abstract_URI_AuthorityFactory(AllAuthoritiesFactory factory) {
        super(factory);
        this.factory = factory;
    }

    protected abstract URI_Parser buildParser(String var1) throws NoSuchAuthorityCodeException;

    @Override
    public abstract Citation getAuthority();

    private URI_Parser getParser(String code) throws NoSuchAuthorityCodeException {
        URI_Parser parser = this.last;
        if (parser == null || !parser.uri.equals(code)) {
            this.last = parser = this.buildParser(code);
        }
        return parser;
    }

    @Override
    protected AuthorityFactory getAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            return this.getAuthorityFactory(this.getParser((String)code).type.type.asSubclass(AuthorityFactory.class), code);
        }
        return super.getAuthorityFactory(code);
    }

    @Override
    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URI_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(this, DatumAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof DatumAuthorityFactory) {
                return (DatumAuthorityFactory)factory;
            }
        }
        return super.getDatumAuthorityFactory(code);
    }

    @Override
    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URI_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(this, CSAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CSAuthorityFactory) {
                return (CSAuthorityFactory)factory;
            }
        }
        return super.getCSAuthorityFactory(code);
    }

    @Override
    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URI_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(this, CRSAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CRSAuthorityFactory) {
                return (CRSAuthorityFactory)factory;
            }
        }
        return super.getCRSAuthorityFactory(code);
    }

    @Override
    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws FactoryException {
        if (code != null) {
            URI_Parser parser = this.getParser(code);
            parser.logWarningIfTypeMismatch(this, CoordinateOperationAuthorityFactory.class);
            AuthorityFactory factory = this.getVersionedFactory(parser);
            if (factory instanceof CoordinateOperationAuthorityFactory) {
                return (CoordinateOperationAuthorityFactory)factory;
            }
        }
        return super.getCoordinateOperationAuthorityFactory(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorityFactory getVersionedFactory(URI_Parser parser) throws FactoryException {
        AuthorityFactory factory;
        Version version = parser.version;
        if (version == null) {
            return null;
        }
        SortedMap<Version, AuthorityFactory> sortedMap = this.byVersions;
        synchronized (sortedMap) {
            factory = (AuthorityFactory)this.byVersions.get(version);
            if (factory == null && (factory = this.createVersionedFactory(version)) != null) {
                this.byVersions.put(version, factory);
            }
        }
        return factory;
    }

    protected AuthorityFactory createVersionedFactory(Version version) throws FactoryException {
        Hints hints = new Hints(this.factory.getImplementationHints());
        hints.put((Object)Hints.VERSION, (Object)version);
        List<AuthorityFactory> factories = Arrays.asList(new AuthorityFactory[]{new AllAuthoritiesFactory(hints), this.factory});
        return FallbackAuthorityFactory.create(factories);
    }

    @Override
    protected String toBackingFactoryCode(String code) throws FactoryException {
        return this.getParser(code).getAuthorityCode();
    }
}

