/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers.xsi;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.geotools.xml.XSIElementHandler;
import org.geotools.xml.handlers.xsi.AnyHandler;
import org.geotools.xml.handlers.xsi.ChoiceHandler;
import org.geotools.xml.handlers.xsi.ElementGroupingHandler;
import org.geotools.xml.handlers.xsi.ElementTypeHandler;
import org.geotools.xml.handlers.xsi.GroupHandler;
import org.geotools.xml.handlers.xsi.SchemaHandler;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Sequence;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SequenceHandler
extends ElementGroupingHandler {
    public static final String LOCALNAME = "sequence";
    private String id;
    private int maxOccurs;
    private int minOccurs;
    private List children;
    private DefaultSequence cache = null;

    @Override
    public int hashCode() {
        return LOCALNAME.hashCode() * (this.id == null ? 1 : this.id.hashCode()) + (this.children == null ? 2 : this.children.hashCode());
    }

    @Override
    public XSIElementHandler getHandler(String namespaceURI, String localName) {
        logger.finest("Getting Handler for " + localName + " :: " + namespaceURI);
        if ("any".equalsIgnoreCase(localName)) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            AnyHandler ah = new AnyHandler();
            this.children.add(ah);
            return ah;
        }
        if ("choice".equalsIgnoreCase(localName)) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            ChoiceHandler ah = new ChoiceHandler();
            this.children.add(ah);
            return ah;
        }
        if ("element".equalsIgnoreCase(localName)) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            ElementTypeHandler ah = new ElementTypeHandler();
            this.children.add(ah);
            return ah;
        }
        if ("group".equalsIgnoreCase(localName)) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            GroupHandler ah = new GroupHandler();
            this.children.add(ah);
            return ah;
        }
        if (LOCALNAME.equalsIgnoreCase(localName)) {
            if (this.children == null) {
                this.children = new LinkedList();
            }
            SequenceHandler ah = new SequenceHandler();
            this.children.add(ah);
            return ah;
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String localName, Attributes atts) {
        String minOccurs1;
        String maxOccurs1;
        this.id = atts.getValue("", "id");
        if (this.id == null) {
            this.id = atts.getValue(namespaceURI, "id");
        }
        if ((maxOccurs1 = atts.getValue("", "maxOccurs")) == null) {
            maxOccurs1 = atts.getValue(namespaceURI, "maxOccurs");
        }
        if ((minOccurs1 = atts.getValue("", "minOccurs")) == null) {
            minOccurs1 = atts.getValue(namespaceURI, "minOccurs");
        }
        this.minOccurs = minOccurs1 != null && !"".equalsIgnoreCase(minOccurs1) ? Integer.parseInt(minOccurs1) : 1;
        this.maxOccurs = maxOccurs1 != null && !"".equalsIgnoreCase(maxOccurs1) ? ("unbounded".equalsIgnoreCase(maxOccurs1) ? Integer.MAX_VALUE : Integer.parseInt(maxOccurs1)) : 1;
    }

    @Override
    public String getLocalName() {
        return LOCALNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ElementGrouping compress(SchemaHandler parent) throws SAXException {
        SequenceHandler sequenceHandler = this;
        synchronized (sequenceHandler) {
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = new DefaultSequence();
        }
        this.cache.id = this.id;
        this.cache.minOccurs = this.minOccurs;
        this.cache.maxOccurs = this.maxOccurs;
        logger.finest(this.id + " :: This Sequence has " + (this.children == null ? 0 : this.children.size()) + " children");
        if (this.children != null) {
            this.cache.children = new ElementGrouping[this.children.size()];
            for (int i = 0; i < this.cache.children.length; ++i) {
                this.cache.children[i] = ((ElementGroupingHandler)this.children.get(i)).compress(parent);
            }
        }
        this.children = null;
        this.id = null;
        return this.cache;
    }

    @Override
    public int getHandlerType() {
        return 16;
    }

    @Override
    public void endElement(String namespaceURI, String localName) {
    }

    private static class DefaultSequence
    implements Sequence {
        ElementGrouping[] children;
        String id;
        int minOccurs;
        int maxOccurs;

        private DefaultSequence() {
        }

        @Override
        public Element findChildElement(String name) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.length; ++i) {
                Element t = this.children[i].findChildElement(name);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        @Override
        public ElementGrouping[] getChildren() {
            return this.children;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public int getMaxOccurs() {
            return this.maxOccurs;
        }

        @Override
        public int getMinOccurs() {
            return this.minOccurs;
        }

        @Override
        public int getGrouping() {
            return 8;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.children == null) {
                return null;
            }
            for (int i = 0; i < this.children.length; ++i) {
                Element t = this.children[i].findChildElement(localName, namespaceURI);
                if (t == null) continue;
                return t;
            }
            return null;
        }
    }
}

