/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Map;
import org.geotools.util.DerivedMap;

final class UnprefixedMap
extends DerivedMap<String, String, Object> {
    private final String prefix;
    private final boolean hasName;
    private final boolean hasAlias;

    public UnprefixedMap(Map<String, ?> base, String prefix) {
        super(base, String.class);
        this.prefix = prefix.trim();
        String nameKey = this.prefix + "name";
        String aliasKey = this.prefix + "alias";
        boolean hasName = false;
        boolean hasAlias = false;
        for (String value : base.keySet()) {
            String candidate = value.toString().trim();
            if (UnprefixedMap.keyMatches(nameKey, candidate)) {
                hasName = true;
                if (!hasAlias) continue;
                break;
            }
            if (!UnprefixedMap.keyMatches(aliasKey, candidate)) continue;
            hasAlias = true;
            if (!hasName) continue;
            break;
        }
        this.hasName = hasName;
        this.hasAlias = hasAlias;
    }

    protected String baseToDerived(String key) {
        int length = this.prefix.length();
        String textualKey = key.trim();
        if (textualKey.regionMatches(true, 0, this.prefix, 0, length)) {
            return textualKey.substring(length).trim();
        }
        if (this.isPlainKey(textualKey)) {
            return textualKey;
        }
        return null;
    }

    protected String derivedToBase(String key) {
        String textualKey = key.trim();
        if (this.isPlainKey(textualKey)) {
            return textualKey;
        }
        return this.prefix + textualKey;
    }

    private boolean isPlainKey(String key) {
        return !this.hasName && UnprefixedMap.keyMatches("name", key) || !this.hasAlias && UnprefixedMap.keyMatches("alias", key);
    }

    private static boolean keyMatches(String key, String candidate) {
        int length = key.length();
        return candidate.regionMatches(true, 0, key, 0, length) && (candidate.length() == length || candidate.charAt(length) == '_');
    }
}

