/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.Unit;
import org.geotools.measure.Measure;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import tec.uom.se.format.SimpleUnitFormat;

public class MeasureConverterFactory
implements ConverterFactory {
    static final Pattern MEASURE_PATTERN = Pattern.compile("\\s*([-\\+]?[0-9]*\\.?[0-9]*(?:[eE][-\\+]?[0-9]+)?)(.*)?");
    public static final Converter CONVERTER = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            if (String.class.equals(target)) {
                Measure m = (Measure)source;
                DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
                if (m.doubleValue() < 1.0E-5) {
                    format.applyPattern("0.###E0");
                } else {
                    format.applyPattern("#0.##");
                }
                String v = format.format(m.doubleValue());
                if (m.getUnit() != null) {
                    return (T)(v + m.getUnit());
                }
                return (T)v;
            }
            if (!Measure.class.isAssignableFrom(target) || source == null) {
                return null;
            }
            String str = (String)source;
            if (str.trim().isEmpty()) {
                return null;
            }
            Matcher matcher = MEASURE_PATTERN.matcher(str);
            if (matcher.matches()) {
                String group;
                double value = Double.parseDouble(matcher.group(1));
                Unit unit = null;
                if (matcher.groupCount() == 2 && !(group = matcher.group(2).trim()).isEmpty()) {
                    unit = SimpleUnitFormat.getInstance().parse((CharSequence)group);
                }
                return (T)new Measure(value, unit);
            }
            throw new IllegalArgumentException("Invalid measure " + str);
        }
    };

    public Converter createConverter(Class source, Class target, Hints hints) {
        if (CharSequence.class.isAssignableFrom(source) && Measure.class.isAssignableFrom(target)) {
            return CONVERTER;
        }
        if (String.class.isAssignableFrom(target) && Measure.class.isAssignableFrom(source)) {
            return CONVERTER;
        }
        return null;
    }
}

