/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v1_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows10.DCPType;
import net.opengis.ows10.DomainType;
import net.opengis.ows10.OperationType;
import net.opengis.ows10.OperationsMetadataType;
import net.opengis.ows10.Ows10Factory;
import org.geotools.wfs.v1_0.WFSCapabilities;
import org.geotools.xsd.AbstractComplexEMFBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.Node;

public class CapabilityBinding
extends AbstractComplexEMFBinding {
    public QName getTarget() {
        return WFSCapabilities.Capability;
    }

    public Class getType() {
        return OperationsMetadataType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Ows10Factory ows10Factory = Ows10Factory.eINSTANCE;
        OperationsMetadataType om = ows10Factory.createOperationsMetadataType();
        Node request = node.getChild("Request");
        OperationType operation = this.getCapabilities(request.getChild("GetCapabilities"), ows10Factory);
        this.addOperation(om, operation);
        operation = this.dft(request.getChild("DescribeFeatureType"), ows10Factory);
        this.addOperation(om, operation);
        operation = this.getFeature(request.getChild("GetFeature"), ows10Factory);
        this.addOperation(om, operation);
        Node nodeOp = request.getChild("Transaction");
        if (nodeOp != null) {
            operation = this.createOperation("Transaction", nodeOp, ows10Factory);
            this.addOperation(om, operation);
        }
        if ((nodeOp = request.getChild("LockFeature")) != null) {
            operation = this.createOperation("LockFeature", nodeOp, ows10Factory);
            this.addOperation(om, operation);
        }
        if ((nodeOp = request.getChild("GetFeatureWithLock")) != null) {
            operation = this.createOperation("GetFeatureWithLock", nodeOp, ows10Factory);
            this.addOperation(om, operation);
        }
        return om;
    }

    private OperationType getFeature(Node node, Ows10Factory ows10Factory) {
        OperationType operationType = this.createOperation("GetFeature", node, ows10Factory);
        this.addParameter(node, ows10Factory, operationType, "ResultFormat");
        return operationType;
    }

    private OperationType dft(Node node, Ows10Factory ows10Factory) {
        OperationType operationType = this.createOperation("DescribeFeatureType", node, ows10Factory);
        this.addParameter(node, ows10Factory, operationType, "SchemaDescriptionLanguage");
        return operationType;
    }

    private OperationType createOperation(String opetationName, Node node, Ows10Factory ows10Factory) {
        if (node == null) {
            return null;
        }
        OperationType operationType = ows10Factory.createOperationType();
        operationType.setName(opetationName);
        this.addDCPTypes(node, operationType);
        return operationType;
    }

    private void addParameter(Node node, Ows10Factory ows10Factory, OperationType operationType, String parameterName) {
        Node paramParentNode = node.getChild(parameterName);
        List<String> paramValues = this.childNames(paramParentNode);
        DomainType domain = ows10Factory.createDomainType();
        domain.setName(parameterName);
        for (String paramValue : paramValues) {
            domain.getValue().add((Object)paramValue);
        }
        operationType.getParameter().add((Object)domain);
    }

    private List<String> childNames(Node node) {
        if (null == node) {
            return Collections.emptyList();
        }
        List children = node.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (Node child : children) {
            InstanceComponent component = child.getComponent();
            String paramValue = component.getName();
            names.add(paramValue);
        }
        return names;
    }

    private OperationType getCapabilities(Node node, Ows10Factory ows10Factory) {
        if (node == null) {
            return null;
        }
        OperationType operationType = ows10Factory.createOperationType();
        operationType.setName("GetCapabilities");
        this.addDCPTypes(node, operationType);
        return operationType;
    }

    private void addDCPTypes(Node node, OperationType operationType) {
        List dcpNodes = node.getChildren(DCPType.class);
        for (Node dcpNode : dcpNodes) {
            DCPType dcp = (DCPType)dcpNode.getValue();
            operationType.getDCP().add((Object)dcp);
        }
    }

    private void addOperation(OperationsMetadataType om, OperationType operation) {
        if (operation != null) {
            om.getOperation().add((Object)operation);
        }
    }
}

