/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.awt.RenderingHints;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.ExpressionToText;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQLCompilerFactory;
import org.geotools.filter.text.ecql.FilterToECQL;
import org.geotools.util.factory.Hints;
import org.geotools.xml.filter.FilterTransformer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class ECQL {
    private ECQL() {
    }

    public static Filter toFilter(String ecqlPredicate) throws CQLException {
        Filter filter = ECQL.toFilter(ecqlPredicate, null);
        return filter;
    }

    public static Filter toFilter(String ecqlPredicate, FilterFactory filterFactory) throws CQLException {
        ECQLCompilerFactory compilerFactory = new ECQLCompilerFactory();
        Filter result = CompilerUtil.parseFilter(ecqlPredicate, compilerFactory, filterFactory);
        return result;
    }

    public static Expression toExpression(String ecqlExpression) throws CQLException {
        return ECQL.toExpression(ecqlExpression, null);
    }

    public static Expression toExpression(String ecqlExpression, FilterFactory filterFactory) throws CQLException {
        ECQLCompilerFactory compilerFactory = new ECQLCompilerFactory();
        Expression expression = CompilerUtil.parseExpression(ecqlExpression, compilerFactory, filterFactory);
        return expression;
    }

    public static List<Filter> toFilterList(String ecqlSequencePredicate) throws CQLException {
        return ECQL.toFilterList(ecqlSequencePredicate, null);
    }

    public static List<Filter> toFilterList(String ecqlSequencePredicate, FilterFactory filterFactory) throws CQLException {
        ECQLCompilerFactory compilerFactory = new ECQLCompilerFactory();
        List<Filter> filters = CompilerUtil.parseFilterList(ecqlSequencePredicate, compilerFactory, filterFactory);
        return filters;
    }

    public static String toCQL(List<Filter> filterList) {
        FilterToECQL toECQL = new FilterToECQL(ECQL.isEwktEncodingEnabled());
        StringBuilder output = new StringBuilder();
        Iterator<Filter> iter = filterList.iterator();
        while (iter.hasNext()) {
            Filter filter = iter.next();
            filter.accept((FilterVisitor)toECQL, (Object)output);
            if (!iter.hasNext()) continue;
            output.append("; ");
        }
        return output.toString();
    }

    public static String toCQL(Filter filter) {
        FilterToECQL toCQL = new FilterToECQL(ECQL.isEwktEncodingEnabled());
        StringBuilder output = (StringBuilder)filter.accept((FilterVisitor)toCQL, (Object)new StringBuilder());
        return output.toString();
    }

    public static boolean isEwktEncodingEnabled() {
        Object value = Hints.getSystemDefault((RenderingHints.Key)Hints.ENCODE_EWKT);
        if (value == null) {
            return true;
        }
        return Boolean.TRUE.equals(value);
    }

    public static String toCQL(Expression expression) {
        ExpressionToText toECQL = new ExpressionToText(ECQL.isEwktEncodingEnabled());
        StringBuilder output = (StringBuilder)expression.accept((ExpressionVisitor)toECQL, (Object)new StringBuilder());
        return output.toString();
    }

    public static final void main(String[] args) {
        System.out.println("ECQL Filters Tester");
        System.out.println("Seperate with \";\" or \"quit\" to finish)");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        FilterTransformer filterTransformer = new FilterTransformer();
        filterTransformer.setIndentation(4);
        block4: while (true) {
            System.out.print(">");
            String line = null;
            try {
                line = reader.readLine();
                if (line == null || line.equals("quit")) {
                    System.out.println("Bye!");
                    break;
                }
                List<Filter> filters = ECQL.toFilterList(line);
                Iterator<Filter> iterator = filters.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    Filter filter = iterator.next();
                    filterTransformer.transform((Object)filter, (OutputStream)System.out);
                }
            }
            catch (IOException e1) {
                Logger.getGlobal().log(Level.INFO, "", e1);
                continue;
            }
            catch (CQLException cqlex) {
                System.out.println(cqlex.getSyntaxError());
                continue;
            }
            catch (TransformerException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                continue;
            }
            break;
        }
    }
}

