/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import it.geosolutions.jaiext.JAIExt;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.TileCache;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.coverage.processing.CoverageParameterWriter;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.Arguments;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public class CoverageProcessor {
    public static final Logger LOGGER = Logging.getLogger(CoverageProcessor.class);
    public static final Level OPERATION = new LogLevel("OPERATION", 780);
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String name1, String name2) {
            return name1.toLowerCase().compareTo(name2.toLowerCase());
        }
    };
    private static CoverageProcessor DEFAULT;
    private static final SoftValueHashMap<Hints, CoverageProcessor> processorsPool;
    private final Map<String, Operation> operations = Collections.synchronizedMap(new TreeMap(COMPARATOR));
    protected final Hints hints;
    protected final FactoryRegistry registry = new FactoryRegistry(Arrays.asList(Operation.class));

    public CoverageProcessor() {
        this(null);
    }

    public CoverageProcessor(RenderingHints hints) {
        this.hints = new Hints();
        this.hints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)Boolean.FALSE);
        this.hints.put((Object)JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)Boolean.FALSE);
        if (hints != null) {
            this.hints.add(hints);
        }
    }

    public static synchronized CoverageProcessor getInstance() {
        return CoverageProcessor.getInstance(null);
    }

    public static synchronized CoverageProcessor getInstance(Hints hints) {
        if (hints == null || hints.isEmpty()) {
            if (DEFAULT == null) {
                DEFAULT = new CacheableCoverageProcessor();
                processorsPool.put((Object)new Hints(), (Object)DEFAULT);
            }
            return DEFAULT;
        }
        if (processorsPool.containsKey((Object)hints)) {
            return (CoverageProcessor)processorsPool.get((Object)hints);
        }
        CacheableCoverageProcessor processor = new CacheableCoverageProcessor((RenderingHints)hints);
        processorsPool.put((Object)hints, (Object)processor);
        return processor;
    }

    public static synchronized void updateProcessors() {
        Set keySet = processorsPool.keySet();
        for (Hints key : keySet) {
            CoverageProcessor processor = (CoverageProcessor)processorsPool.get((Object)key);
            processor.scanForPlugins();
        }
    }

    public static synchronized void removeOperationFromProcessors(String operationName) {
        List operations = JAIExt.getJAINames((String)operationName);
        Set keySet = processorsPool.keySet();
        for (Hints key : keySet) {
            for (String opName : operations) {
                CoverageProcessor processor = (CoverageProcessor)processorsPool.get((Object)key);
                try {
                    Operation op = processor.getOperation(opName);
                    if (op == null) continue;
                    processor.removeOperation(op);
                }
                catch (OperationNotFoundException e) {
                    LOGGER.warning("Operation: " + opName + " not found in CoverageProcessor");
                }
            }
        }
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    final void log(Coverage source, Coverage result, String operationName, boolean fromCache) {
        if (source != result) {
            String interp = "Nearest";
            if (result instanceof Interpolator2D) {
                interp = ImageUtilities.getInterpolationName(((Interpolator2D)result).getInterpolation());
            }
            Locale locale = this.getLocale();
            LogRecord record = Loggings.getResources((Locale)locale).getLogRecord(OPERATION, 2, (Object)CoverageProcessor.getName(source != null ? source : result, locale), (Object)operationName, (Object)interp, (Object)(fromCache ? 1 : 0));
            record.setSourceClassName("org.geotools.coverage.processing.DefaultProcessor");
            record.setSourceMethodName("doOperation");
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
    }

    static Coverage getPrimarySource(ParameterValueGroup parameters) {
        try {
            return (Coverage)parameters.parameter("Source").getValue();
        }
        catch (ParameterNotFoundException exception) {
            return null;
        }
    }

    static String getOperationName(ParameterValueGroup parameters) {
        return parameters.getDescriptor().getName().getCode().trim();
    }

    private static String getName(Coverage coverage, Locale locale) {
        InternationalString name;
        if (coverage instanceof AbstractCoverage && (name = ((AbstractCoverage)coverage).getName()) != null) {
            return name.toString(locale);
        }
        return Vocabulary.getResources((Locale)locale).getString(232);
    }

    public void listOperations(Writer out) throws IOException {
        Collection<Operation> operations = this.getOperations();
        CoverageParameterWriter writer = new CoverageParameterWriter(out);
        ArrayList<ParameterDescriptorGroup> descriptors = new ArrayList<ParameterDescriptorGroup>(operations.size());
        for (Operation operation : operations) {
            if (!(operation instanceof AbstractOperation)) continue;
            descriptors.add(((AbstractOperation)operation).descriptor);
        }
        writer.summary(descriptors, null);
    }

    public void printOperations(Writer out, String[] names) throws OperationNotFoundException, IOException {
        CoverageParameterWriter writer = new CoverageParameterWriter(out);
        String lineSeparator = System.getProperty("line.separator", "\n");
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                Operation operation = this.getOperation(names[i]);
                if (!(operation instanceof AbstractOperation)) continue;
                out.write(lineSeparator);
                writer.format(((AbstractOperation)operation).descriptor);
            }
        } else {
            Collection<Operation> operations = this.getOperations();
            for (Operation operation : operations) {
                if (!(operation instanceof AbstractOperation)) continue;
                out.write(lineSeparator);
                writer.format(((AbstractOperation)operation).descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOperation(Operation operation) throws IllegalStateException {
        Utilities.ensureNonNull((String)"operation", (Object)operation);
        Map<String, Operation> map = this.operations;
        synchronized (map) {
            if (this.operations.isEmpty()) {
                this.scanForPlugins();
            }
            this.addOperation0(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOperation(Operation operation) {
        Utilities.ensureNonNull((String)"operation", (Object)operation);
        Map<String, Operation> map = this.operations;
        synchronized (map) {
            if (this.operations.isEmpty()) {
                return;
            }
            this.operations.remove(operation.getName().trim());
        }
    }

    private void addOperation0(Operation operation) throws IllegalStateException {
        String name = operation.getName().trim();
        Operation old = this.operations.put(name, operation);
        if (old != null && !old.equals(operation)) {
            this.operations.put(old.getName().trim(), old);
            throw new IllegalStateException(Errors.getResources((Locale)this.getLocale()).getString(151, (Object)operation.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Operation> getOperations() {
        Map<String, Operation> map = this.operations;
        synchronized (map) {
            if (this.operations.isEmpty()) {
                this.scanForPlugins();
            }
            return this.operations.values();
        }
    }

    public Operation getOperation(String name) throws OperationNotFoundException {
        Utilities.ensureNonNull((String)"name", (Object)name);
        name = name.trim();
        Map<String, Operation> map = this.operations;
        synchronized (map) {
            Operation operation;
            if (this.operations.isEmpty()) {
                this.scanForPlugins();
            }
            if ((operation = this.operations.get(name)) != null) {
                return operation;
            }
            throw new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(152, (Object)name));
        }
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get((Object)key);
    }

    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) {
        AbstractOperation op;
        Coverage source = CoverageProcessor.getPrimarySource(parameters);
        String operationName = CoverageProcessor.getOperationName(parameters);
        Operation operation = this.getOperation(operationName);
        Object[] interpolations = null;
        if (!operationName.equalsIgnoreCase("Interpolate")) {
            for (GeneralParameterValue param : parameters.values()) {
                Object value;
                if (!(param instanceof ParameterValue) || !((value = ((ParameterValue)param).getValue()) instanceof Interpolator2D)) continue;
                Object[] interp = ((Interpolator2D)((Object)value)).getInterpolations();
                if (interpolations == null) {
                    interpolations = interp;
                    continue;
                }
                if (Arrays.equals(interpolations, interp)) continue;
                interpolations = null;
                break;
            }
        }
        try {
            op = (AbstractOperation)operation;
        }
        catch (ClassCastException cause) {
            OperationNotFoundException exception = new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(152, (Object)operationName));
            exception.initCause((Throwable)cause);
            throw exception;
        }
        Hints localMergeHints = this.hints.clone();
        if (hints != null) {
            localMergeHints.add((RenderingHints)hints);
        }
        Coverage coverage = op.doOperation(parameters, localMergeHints);
        if (interpolations != null && coverage instanceof GridCoverage2D && !(coverage instanceof Interpolator2D)) {
            coverage = Interpolator2D.create((GridCoverage2D)coverage, interpolations);
        }
        this.log(source, coverage, operationName, false);
        return coverage;
    }

    public Coverage doOperation(ParameterValueGroup parameters) throws OperationNotFoundException {
        return this.doOperation(parameters, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForPlugins() {
        Map<String, Operation> map = this.operations;
        synchronized (map) {
            this.registry.getFactories(Operation.class, null, null).filter(operation -> !this.operations.containsKey(operation.getName().trim())).forEach(this::addOperation0);
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        boolean all = arguments.getFlag("-all");
        args = arguments.getRemainingArguments(Integer.MAX_VALUE);
        CoverageProcessor processor = CoverageProcessor.getInstance();
        try {
            if (args.length == 0) {
                processor.listOperations(arguments.out);
            } else {
                processor.printOperations(arguments.out, all ? null : args);
            }
        }
        catch (OperationNotFoundException exception) {
            arguments.out.println(exception.getLocalizedMessage());
        }
        catch (IOException exception) {
            Logger.getGlobal().log(Level.INFO, "", exception);
        }
        arguments.out.flush();
    }

    public static Object getParameter(ParameterBlockJAI parameters, String paramName) {
        Object param;
        block3: {
            param = null;
            if (parameters != null) {
                try {
                    param = parameters.getObjectParameter(paramName);
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.fine("Required parameter is unavailable: " + paramName + ". Returning null ");
                }
            }
        }
        return param;
    }

    static {
        processorsPool = new SoftValueHashMap();
        long targetCapacity = 0x4000000L;
        long maxMemory = Runtime.getRuntime().maxMemory();
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        if (maxMemory >= 0x8000000L && cache.getMemoryCapacity() < 0x4000000L) {
            cache.setMemoryCapacity(0x4000000L);
        }
        LOGGER.config("Java Advanced Imaging: " + JAI.getBuildVersion() + ", TileCache capacity=" + (float)(cache.getMemoryCapacity() / 0x100000L) + " Mb");
        if (cache.getMemoryCapacity() + 0x400000L >= maxMemory) {
            LogRecord record = Loggings.format((Level)Level.SEVERE, (int)20, (Object)((double)maxMemory / 1048576.0));
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        boolean isJaiExtEnabled = ImageWorker.isJaiExtEnabled();
        LOGGER.config("JAI-Ext operations are " + (isJaiExtEnabled ? "enabled" : "disabled"));
    }

    private static final class CacheableCoverageProcessor
    extends CoverageProcessor {
        public CacheableCoverageProcessor() {
        }

        public CacheableCoverageProcessor(RenderingHints hints) {
            super(hints);
        }

        @Override
        protected void addOperation(Operation operation) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class LogLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        protected LogLevel(String name, int level) {
            super(name, level);
        }
    }
}

