/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.WKBReader;

public class WKBLoaderSPI
implements FootprintLoaderSpi {
    @Override
    public FootprintLoader createLoader() {
        return new WKBLoader();
    }

    public class WKBLoader
    implements FootprintLoader {
        WKBReader reader = new WKBReader();

        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkb");
            if (file.exists()) {
                try (FileInputStream is = new FileInputStream(file);){
                    Geometry geometry = this.reader.read((InStream)new InputStreamInStream((InputStream)is));
                    return geometry;
                }
            }
            return null;
        }

        @Override
        public List<File> getFootprintFiles(String pathNoExtension) {
            File sidecar = new File(pathNoExtension + ".wkb");
            if (sidecar.exists()) {
                return Arrays.asList(sidecar);
            }
            return Collections.emptyList();
        }
    }
}

