/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.PixelTranslation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class SpatialRequestHelper {
    private static final Logger LOGGER = Logging.getLogger(SpatialRequestHelper.class);
    BoundingBox requestedBBox;
    BoundingBox cropBBox;
    Rectangle requestedRasterArea;
    Rectangle destinationRasterArea;
    CoordinateReferenceSystem requestCRS;
    AffineTransform requestedGridToWorld;
    double[] requestedResolution;
    GeneralEnvelope requestedBBOXInCoverageGeographicCRS;
    MathTransform requestCRSToCoverageGeographicCRS2D;
    MathTransform destinationToSourceTransform;
    CoverageProperties coverageProperties;
    boolean empty;
    boolean needsReprojection = false;
    GeneralEnvelope approximateRequestedBBoInNativeCRS;

    public void setRequestedGridGeometry(GridGeometry2D gridGeometry) {
        Utilities.ensureNonNull((String)"girdGeometry", (Object)gridGeometry);
        this.requestedBBox = new ReferencedEnvelope((Envelope)gridGeometry.getEnvelope2D());
        this.requestedRasterArea = gridGeometry.getGridRange2D().getBounds();
        this.requestedGridToWorld = (AffineTransform)gridGeometry.getGridToCRS2D();
    }

    public void setCoverageProperties(CoverageProperties coverageProperties) {
        this.coverageProperties = coverageProperties;
    }

    public void prepare() throws DataSourceException {
        if (this.requestedBBox == null) {
            this.requestedBBox = this.coverageProperties.bbox;
            this.cropBBox = this.coverageProperties.bbox;
            this.requestedRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.destinationRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.requestedResolution = (double[])this.coverageProperties.fullResolution.clone();
            this.requestedGridToWorld = (AffineTransform)this.coverageProperties.gridToWorld2D;
            return;
        }
        this.computeRequestSpatialElements();
    }

    private void computeRequestSpatialElements() throws DataSourceException {
        this.inspectCoordinateReferenceSystems();
        this.computeCropBBOX();
        if (this.empty || this.cropBBox != null && this.cropBBox.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RequestedBBox empty or null");
            }
            this.empty = true;
            return;
        }
        this.computeCropRasterArea();
        if (this.empty || this.destinationRasterArea != null && this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CropRasterArea empty or null");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.requestedRasterArea.toString());
            LOGGER.log(Level.FINER, sb.toString());
        }
        this.computeRequestedResolution();
    }

    private void inspectCoordinateReferenceSystems() throws DataSourceException {
        this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)this.coverageProperties.crs2D)) {
            try {
                this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.coverageProperties.crs2D, (boolean)true);
            }
            catch (FactoryException e) {
                throw new DataSourceException("Unable to inspect request CRS", e);
            }
        }
        if (this.destinationToSourceTransform != null && this.destinationToSourceTransform.isIdentity()) {
            this.destinationToSourceTransform = null;
        } else {
            this.needsReprojection = true;
            if (this.destinationToSourceTransform instanceof AffineTransform) {
                AffineTransform mutableTransform = (AffineTransform)this.requestedGridToWorld.clone();
                mutableTransform.preConcatenate((AffineTransform)this.destinationToSourceTransform);
                try {
                    MathTransform tempTransform = PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)mutableTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                    this.requestedBBox = new ReferencedEnvelope((Envelope)CRS.transform((MathTransform)tempTransform, (Envelope)new GeneralEnvelope((Rectangle2D)this.requestedRasterArea)));
                }
                catch (MismatchedDimensionException e) {
                    throw new DataSourceException("Unable to inspect request CRS", e);
                }
                catch (TransformException e) {
                    throw new DataSourceException("Unable to inspect request CRS", e);
                }
                this.destinationToSourceTransform = null;
                this.needsReprojection = false;
            }
        }
    }

    private void computeCropRasterArea() throws DataSourceException {
        MathTransform2D requestedWorldToGrid;
        if (this.cropBBox == null) {
            this.destinationRasterArea = null;
            return;
        }
        try {
            requestedWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException(e);
        }
        if (this.destinationToSourceTransform == null || this.destinationToSourceTransform.isIdentity()) {
            try {
                this.destinationRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)new GeneralEnvelope((Envelope)this.cropBBox)), PixelInCell.CELL_CORNER, false).toRectangle();
            }
            catch (IllegalStateException e) {
                throw new DataSourceException(e);
            }
            catch (TransformException e) {
                throw new DataSourceException(e);
            }
        }
        try {
            GeneralEnvelope cropBBOXInRequestCRS = CRS.transform((Envelope)this.cropBBox, (CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
            cropBBOXInRequestCRS.setCoordinateReferenceSystem(this.requestedBBox.getCoordinateReferenceSystem());
            cropBBOXInRequestCRS.intersect((Envelope)this.requestedBBox);
            this.destinationRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)cropBBOXInRequestCRS), PixelInCell.CELL_CORNER, false).toRectangle();
            XRectangle2D.intersect((Rectangle2D)this.destinationRasterArea, (Rectangle2D)this.requestedRasterArea, (Rectangle2D)this.destinationRasterArea);
        }
        catch (NoninvertibleTransformException e) {
            throw new DataSourceException(e);
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        if (this.destinationRasterArea.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Requested envelope too small resulting in empty cropped raster region. cropBbox:" + this.cropBBox);
            }
            this.empty = true;
            return;
        }
    }

    private void computeRequestedResolution() throws DataSourceException {
        try {
            if (this.requestedGridToWorld instanceof LinearTransform) {
                if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                    this.requestedResolution = null;
                    GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.destinationRasterArea), (Envelope)this.cropBBox);
                    AffineTransform tempTransform = geMapper.createAffineTransform();
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)tempTransform), XAffineTransform.getScaleY0((AffineTransform)tempTransform)};
                } else {
                    this.requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld)};
                }
            } else {
                throw new UnsupportedOperationException(Errors.format((int)205, (Object)this.requestedGridToWorld.toString()));
            }
            return;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, using highest available");
            this.requestedResolution = this.coverageProperties.fullResolution;
            return;
        }
    }

    private void computeCropBBOX() throws DataSourceException {
        if (this.requestCRS == null) {
            this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        }
        try {
            if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                GeneralEnvelope temp = new GeneralEnvelope((Envelope)CRS.transform((Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.coverageProperties.crs2D));
                temp.setCoordinateReferenceSystem(this.coverageProperties.crs2D);
                this.cropBBox = new ReferencedEnvelope((Envelope)temp);
                this.needsReprojection = true;
            } else {
                this.cropBBox = new ReferencedEnvelope(this.requestedBBox.getMinX(), this.requestedBBox.getMaxX(), this.requestedBBox.getMinY(), this.requestedBBox.getMaxY(), this.coverageProperties.crs2D);
            }
            if (!this.cropBBox.intersects((BoundingBox)this.coverageProperties.bbox)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The computed CropBoundingBox " + this.cropBBox + " Doesn't intersect the coverage BoundingBox " + (Object)((Object)this.coverageProperties.bbox) + " resulting in an empty request");
                }
                this.cropBBox = null;
                this.empty = true;
                return;
            }
            this.cropBBox = new ReferencedEnvelope(((ReferencedEnvelope)this.cropBBox).intersection(this.coverageProperties.bbox), this.coverageProperties.crs2D);
            return;
        }
        catch (TransformException te) {
            block17: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
                try {
                    if (this.coverageProperties.geographicCRS2D != null && this.coverageProperties.geographicBBox != null) {
                        if (!CRS.equalsIgnoreMetadata((Object)this.coverageProperties.geographicCRS2D, (Object)this.requestCRS)) {
                            this.requestCRSToCoverageGeographicCRS2D = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.coverageProperties.geographicCRS2D, (boolean)true);
                            if (!this.requestCRSToCoverageGeographicCRS2D.isIdentity()) {
                                this.requestedBBOXInCoverageGeographicCRS = CRS.transform((Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.coverageProperties.geographicCRS2D);
                                this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS2D);
                            }
                        }
                        if (this.requestedBBOXInCoverageGeographicCRS == null) {
                            this.requestedBBOXInCoverageGeographicCRS = new GeneralEnvelope(this.requestCRS);
                        }
                        if (!this.requestedBBOXInCoverageGeographicCRS.intersects((Envelope)this.coverageProperties.geographicBBox, true)) {
                            this.cropBBox = null;
                            this.empty = true;
                            return;
                        }
                        this.requestedBBOXInCoverageGeographicCRS.intersect((Envelope)this.coverageProperties.geographicBBox);
                        this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS2D);
                        this.approximateRequestedBBoInNativeCRS = CRS.transform((Envelope)this.requestedBBOXInCoverageGeographicCRS, (CoordinateReferenceSystem)this.coverageProperties.crs2D);
                        this.approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.coverageProperties.crs2D);
                        this.cropBBox = new ReferencedEnvelope((Envelope)this.approximateRequestedBBoInNativeCRS);
                        return;
                    }
                }
                catch (TransformException te2) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, te2.getLocalizedMessage(), te2);
                    }
                }
                catch (FactoryException fe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block17;
                    LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
                }
            }
            LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
            this.cropBBox = null;
            return;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isNeedsReprojection() {
        return this.needsReprojection;
    }

    public BoundingBox getRequestedBBox() {
        return this.requestedBBox;
    }

    public Rectangle getRequestedRasterArea() {
        return (Rectangle)(this.requestedRasterArea != null ? this.requestedRasterArea.clone() : this.requestedRasterArea);
    }

    public double[] getRequestedResolution() {
        return this.requestedResolution != null ? (double[])this.requestedResolution.clone() : null;
    }

    public Rectangle getDestinationRasterArea() {
        return this.destinationRasterArea;
    }

    public BoundingBox getCropBBox() {
        return this.cropBBox;
    }

    public AffineTransform getRequestedGridToWorld() {
        return this.requestedGridToWorld;
    }

    public void setRequestedBBox(BoundingBox requestedBBox) {
        this.requestedBBox = requestedBBox;
    }

    public void setRequestedRasterArea(Rectangle requestedRasterArea) {
        this.requestedRasterArea = requestedRasterArea;
    }

    public void setRequestedGridToWorld(AffineTransform requestedGridToWorld) {
        this.requestedGridToWorld = requestedGridToWorld;
    }

    public CoverageProperties getCoverageProperties() {
        return this.coverageProperties;
    }

    public String toString() {
        return "SpatialRequestHelper [requestedBBox=" + this.requestedBBox + ", cropBBox=" + this.cropBBox + ", requestedRasterArea=" + this.requestedRasterArea + ", destinationRasterArea=" + this.destinationRasterArea + ", requestCRS=" + this.requestCRS + ", requestedGridToWorld=" + this.requestedGridToWorld + ", requestedResolution=" + Arrays.toString(this.requestedResolution) + ", requestedBBOXInCoverageGeographicCRS=" + this.requestedBBOXInCoverageGeographicCRS + ", requestCRSToCoverageGeographicCRS2D=" + this.requestCRSToCoverageGeographicCRS2D + ", destinationToSourceTransform=" + this.destinationToSourceTransform + ", coverageProperties=" + this.coverageProperties + ", empty=" + this.empty + ", needsReprojection=" + this.needsReprojection + ", approximateRequestedBBoInNativeCRS=" + this.approximateRequestedBBoInNativeCRS + "]";
    }

    public static class CoverageProperties {
        ReferencedEnvelope bbox;
        Rectangle rasterArea;
        double[] fullResolution;
        MathTransform2D gridToWorld2D;
        CoordinateReferenceSystem crs2D;
        ReferencedEnvelope geographicBBox;
        CoordinateReferenceSystem geographicCRS2D;

        public ReferencedEnvelope getBbox() {
            return this.bbox;
        }

        public void setBbox(ReferencedEnvelope bbox) {
            this.bbox = bbox;
        }

        public Rectangle getRasterArea() {
            return this.rasterArea;
        }

        public void setRasterArea(Rectangle rasterArea) {
            this.rasterArea = rasterArea;
        }

        public double[] getFullResolution() {
            return this.fullResolution;
        }

        public void setFullResolution(double[] fullResolution) {
            this.fullResolution = fullResolution;
        }

        public MathTransform2D getGridToWorld2D() {
            return this.gridToWorld2D;
        }

        public void setGridToWorld2D(MathTransform2D gridToWorld2D) {
            this.gridToWorld2D = gridToWorld2D;
        }

        public CoordinateReferenceSystem getCrs2D() {
            return this.crs2D;
        }

        public void setCrs2D(CoordinateReferenceSystem crs2d) {
            this.crs2D = crs2d;
        }

        public ReferencedEnvelope getGeographicBBox() {
            return this.geographicBBox;
        }

        public void setGeographicBBox(ReferencedEnvelope geographicBBox) {
            this.geographicBBox = geographicBBox;
        }

        public CoordinateReferenceSystem getGeographicCRS2D() {
            return this.geographicCRS2D;
        }

        public void setGeographicCRS2D(CoordinateReferenceSystem geographicCRS2D) {
            this.geographicCRS2D = geographicCRS2D;
        }
    }
}

