/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Id;
import org.opengis.filter.NativeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

class RepeatedFilterVisitor
extends DefaultFilterVisitor {
    Map<Object, AtomicInteger> objectCounter = new HashMap<Object, AtomicInteger>();

    RepeatedFilterVisitor() {
    }

    private void collect(Object object) {
        AtomicInteger counter = this.objectCounter.get(object);
        if (counter == null) {
            counter = new AtomicInteger(1);
            this.objectCounter.put(object, counter);
        } else {
            counter.incrementAndGet();
        }
    }

    public Set<Object> getRepeatedObjects() {
        return this.objectCounter.entrySet().stream().filter(e -> ((AtomicInteger)e.getValue()).get() > 1).map(e -> e.getKey()).collect(Collectors.toSet());
    }

    public Object visit(And filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Id filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Not filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Or filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsLike filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsNull filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(PropertyIsNil filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(BBOX filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Beyond filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Contains filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Crosses filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Disjoint filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(DWithin filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Equals filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Intersects filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Overlaps filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Touches filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visit(Within filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }

    public Object visitNullFilter(Object data) {
        this.collect(data);
        return super.visitNullFilter(data);
    }

    public Object visit(NilExpression expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Add expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Divide expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Function expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Literal expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Multiply expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(PropertyName expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(Subtract expression, Object data) {
        this.collect(expression);
        return super.visit(expression, data);
    }

    public Object visit(After after, Object data) {
        this.collect(after);
        return super.visit(after, data);
    }

    public Object visit(AnyInteracts anyInteracts, Object data) {
        this.collect(anyInteracts);
        return super.visit(anyInteracts, data);
    }

    public Object visit(Before before, Object data) {
        this.collect(before);
        return super.visit(before, data);
    }

    public Object visit(Begins begins, Object data) {
        this.collect(begins);
        return super.visit(begins, data);
    }

    public Object visit(BegunBy begunBy, Object data) {
        this.collect(begunBy);
        return super.visit(begunBy, data);
    }

    public Object visit(During during, Object data) {
        this.collect(during);
        return super.visit(during, data);
    }

    public Object visit(EndedBy endedBy, Object data) {
        this.collect(endedBy);
        return super.visit(endedBy, data);
    }

    public Object visit(Ends ends, Object data) {
        this.collect(ends);
        return super.visit(ends, data);
    }

    public Object visit(Meets meets, Object data) {
        this.collect(meets);
        return super.visit(meets, data);
    }

    public Object visit(MetBy metBy, Object data) {
        this.collect(metBy);
        return super.visit(metBy, data);
    }

    public Object visit(OverlappedBy overlappedBy, Object data) {
        this.collect(overlappedBy);
        return super.visit(overlappedBy, data);
    }

    public Object visit(TContains contains, Object data) {
        this.collect(contains);
        return super.visit(contains, data);
    }

    public Object visit(TEquals equals, Object data) {
        this.collect(equals);
        return super.visit(equals, data);
    }

    public Object visit(TOverlaps contains, Object data) {
        this.collect(contains);
        return super.visit(contains, data);
    }

    public Object visit(NativeFilter filter, Object data) {
        this.collect(filter);
        return super.visit(filter, data);
    }
}

