/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.renderer.lite.FilterMemoizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.xml.sax.helpers.NamespaceSupport;

class MemoryFilterOptimizer
extends DuplicatingFilterVisitor {
    static final Object NULL_PLACEHOLDER = new Object();
    private final Set<Object> memoizeCandidates;
    Map<Expression, Expression> expressionReplacements = new HashMap<Expression, Expression>();
    Map<Filter, Filter> filterReplacements = new HashMap<Filter, Filter>();
    SimpleFeatureType simpleFeatureType;

    public MemoryFilterOptimizer(FeatureType schema, Set<Object> memoizeCandidates) {
        if (schema instanceof SimpleFeatureType) {
            this.simpleFeatureType = (SimpleFeatureType)schema;
        }
        this.memoizeCandidates = memoizeCandidates;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(And filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Id filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Not filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Or filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Contains filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Equals filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Touches filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Within filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public <T extends Filter> T memoize(T filter, Object extraData, BiFunction<T, Object, Object> duplicator) {
        if (!this.memoizeCandidates.contains(filter)) {
            return (T)((Filter)duplicator.apply(filter, extraData));
        }
        Filter replacement = this.filterReplacements.get(filter);
        if (replacement == null) {
            Filter duplicated = (Filter)duplicator.apply(filter, extraData);
            replacement = FilterMemoizer.memoize(duplicated);
            this.filterReplacements.put(filter, replacement);
        }
        return (T)replacement;
    }

    public Object visit(PropertyName expression, Object extraData) {
        Object replacement = this.expressionReplacements.get(expression);
        if (replacement == null) {
            replacement = this.simpleFeatureType != null && this.simpleFeatureType.indexOf(expression.getPropertyName()) >= 0 ? new IndexPropertyName(this.simpleFeatureType, expression) : (this.memoizeCandidates.contains(expression) ? new MemoizedPropertyName(expression) : expression);
            this.expressionReplacements.put((Expression)expression, (Expression)replacement);
        }
        return replacement;
    }

    static class MemoizedPropertyName
    implements PropertyName {
        PropertyName delegate;
        Object lastFeature = NULL_PLACEHOLDER;
        Object lastResult;
        Class lastContext;

        public MemoizedPropertyName(PropertyName delegate) {
            this.delegate = delegate;
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            if (object != this.lastFeature || this.lastContext != null) {
                this.lastResult = this.delegate.evaluate(object);
                this.lastFeature = object;
                this.lastContext = null;
            }
            return this.lastResult;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            if (object != this.lastFeature || !Objects.equals(this.lastContext, context)) {
                this.lastResult = this.delegate.evaluate(object, context);
                this.lastContext = context;
            }
            return (T)this.lastResult;
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }
    }

    static class IndexPropertyName
    implements PropertyName {
        private final SimpleFeatureType schema;
        PropertyName delegate;
        int index;

        public IndexPropertyName(SimpleFeatureType schema, PropertyName delegate) {
            this.delegate = delegate;
            this.schema = schema;
            this.index = schema.indexOf(delegate.getPropertyName());
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            if (object instanceof SimpleFeature && ((SimpleFeature)object).getFeatureType() == this.schema) {
                SimpleFeature sf = (SimpleFeature)object;
                try {
                    return sf.getAttribute(this.index);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Could not locate attribute at index " + this.index + " on feature " + object, e);
                }
            }
            return this.delegate.evaluate(object);
        }

        public <T> T evaluate(Object object, Class<T> context) {
            if (object instanceof SimpleFeature && ((SimpleFeature)object).getFeatureType() == this.schema) {
                SimpleFeature sf = (SimpleFeature)object;
                try {
                    Object value = sf.getAttribute(this.index);
                    if (context == null || context.isInstance(value)) {
                        return (T)value;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Could not locate attribute at index " + this.index + " on feature " + object, e);
                }
            }
            return (T)this.delegate.evaluate(object, context);
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }
    }
}

