/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.geometry.BoundingBox;

class FastBBOX
implements BBOX,
BinarySpatialOperator,
BinaryComparisonOperator {
    PropertyName property;
    Envelope envelope;
    FilterFactory factory;

    public FastBBOX(PropertyName propertyName, Envelope env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    public PropertyName getProperty() {
        return this.property;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public BoundingBox getBounds() {
        return ReferencedEnvelope.reference((Envelope)this.envelope);
    }

    public Expression getExpression1() {
        return this.property;
    }

    public Expression getExpression2() {
        return this.factory.literal((Object)this.envelope);
    }

    public Object accept(FilterVisitor visitor, Object context) {
        Object result = visitor.visit((BBOX)this, context);
        if (!(result instanceof BBOX)) {
            return result;
        }
        BBOX clone = (BBOX)result;
        if (clone.getExpression1().equals(this.getExpression1()) && clone.getExpression2().equals(this.getExpression2())) {
            return new FastBBOX(this.property, this.envelope, this.factory);
        }
        return result;
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        Geometry other = (Geometry)this.property.evaluate(feature);
        if (other == null) {
            return false;
        }
        return other.getEnvelopeInternal().intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "FastBBOX [property=" + this.property + ", envelope=" + this.envelope + "]";
    }
}

