/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.rendered.viewer;

import it.geosolutions.rendered.viewer.HTMLBuilder;
import it.geosolutions.rendered.viewer.HTMLRenderer;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageReadParam;

public final class HTMLRenderers {
    private static List<HTMLRenderer> renderers = new ArrayList<HTMLRenderer>();

    public static List<HTMLRenderer> getRenderers() {
        return renderers;
    }

    public static void addRendered(HTMLRenderer renderer) {
        renderers.add(renderer);
    }

    private HTMLRenderers() {
    }

    static {
        renderers.add(new ArrayRenderer());
        renderers.add(new ImageReadParamRenderer());
    }

    private static class ImageReadParamRenderer
    implements HTMLRenderer {
        private ImageReadParamRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && ImageReadParam.class.isAssignableFrom(o.getClass());
        }

        @Override
        public String render(Object o) {
            ImageReadParam param = (ImageReadParam)o;
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(o.getClass().toString()).append("\n");
            int ssx = param.getSourceXSubsampling();
            int ssy = param.getSourceYSubsampling();
            Rectangle rect = param.getSourceRegion();
            Point p = param.getDestinationOffset();
            int[] bands = param.getSourceBands();
            if (rect != null) {
                sb.append(String.format("    SourceRegion(Rectangle)[x:%d, y:%d, width:%d, height:%d]\n", rect.x, rect.y, rect.width, rect.height));
            }
            sb.append(String.format("    SourceSubsampling[ssx:%d, ssy:%d]\n", ssx, ssy));
            if (bands != null) {
                sb.append("    SourceBands[").append(HTMLBuilder.render(bands)).append("]\n");
            }
            if (p != null) {
                sb.append(String.format("    DestinationOffset(Point)[x:%d, y:%d]", p.x, p.y));
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class ArrayRenderer
    implements HTMLRenderer {
        private ArrayRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o != null && o.getClass().isArray();
        }

        @Override
        public String render(Object o) {
            int length = Array.getLength(o);
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < length; ++i) {
                sb.append(HTMLBuilder.render(Array.get(o, i)));
                if (i < length - 1) {
                    sb.append(", ");
                    continue;
                }
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

