/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Date;
import java.util.logging.Logger;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsNilImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public abstract class CompareFilterImpl
extends BinaryComparisonAbstract {
    static final Logger LOGGER = Logging.getLogger(CompareFilterImpl.class);

    protected CompareFilterImpl(Expression e1, Expression e2) {
        this(e1, e2, true);
    }

    protected CompareFilterImpl(Expression e1, Expression e2, boolean matchCase) {
        super(e1, e2, matchCase);
    }

    @Override
    public void setExpression1(Expression leftValue) {
        this.expression1 = leftValue;
    }

    @Override
    public void setExpression2(Expression rightValue) {
        this.expression2 = rightValue;
    }

    protected int compare(Comparable leftObj, Comparable rightObj) {
        double right;
        if (leftObj == null || rightObj == null) {
            throw new NullPointerException("Left and right objects are meant to be non null)");
        }
        if (!(leftObj instanceof Number) || !(rightObj instanceof Number)) {
            if (leftObj.getClass() != rightObj.getClass()) {
                if (leftObj instanceof Date || rightObj instanceof Date) {
                    Date leftConverted = null;
                    Date rightConverted = null;
                    if (!(leftObj instanceof Date)) {
                        leftConverted = (Date)Converters.convert((Object)leftObj, Date.class);
                    }
                    if (!(rightObj instanceof Date)) {
                        rightConverted = (Date)Converters.convert((Object)rightObj, Date.class);
                    }
                    if (leftConverted == null || rightConverted == null) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    } else {
                        leftObj = leftConverted;
                        rightObj = rightConverted;
                    }
                } else if (leftObj instanceof Number && rightObj.getClass() == String.class) {
                    try {
                        rightObj = Double.parseDouble((String)rightObj);
                        leftObj = ((Number)leftObj).doubleValue();
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else if (leftObj.getClass() == String.class && rightObj instanceof Number) {
                    try {
                        leftObj = Double.parseDouble((String)leftObj);
                        rightObj = ((Number)rightObj).doubleValue();
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                } else {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            } else if (leftObj instanceof String && rightObj instanceof String) {
                try {
                    leftObj = Double.parseDouble((String)leftObj);
                    rightObj = Double.parseDouble((String)rightObj);
                }
                catch (Exception e) {
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                }
            }
            return leftObj.compareTo(rightObj);
        }
        double left = ((Number)leftObj).doubleValue();
        return left > (right = ((Number)rightObj).doubleValue()) ? 1 : (left == right ? 0 : -1);
    }

    public String toString() {
        if (this instanceof IsNullImpl) {
            return "[ " + this.expression1 + " IS NULL ]";
        }
        if (this instanceof IsNilImpl) {
            return "[ " + this.expression1 + " IS NIL ]";
        }
        String operator = null;
        if (this instanceof IsEqualsToImpl) {
            operator = " = ";
        } else if (this instanceof IsLessThenImpl) {
            operator = " < ";
        } else if (this instanceof IsGreaterThanImpl) {
            operator = " > ";
        } else if (this instanceof PropertyIsLessThanOrEqualTo) {
            operator = " <= ";
        } else if (this instanceof IsGreaterThanOrEqualToImpl) {
            operator = " >= ";
        } else if (this instanceof IsNotEqualToImpl) {
            operator = " != ";
        }
        return "[ " + this.expression1 + operator + this.expression2 + " ]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CompareFilterImpl cFilter = (CompareFilterImpl)obj;
            Expression cfe1 = cFilter.getExpression1();
            Expression cfe2 = cFilter.getExpression2();
            return (this.expression1 == cfe1 || this.expression1 != null && this.expression1.equals(cfe1)) && (this.expression2 == cfe2 || this.expression2 != null && this.expression2.equals(cfe2));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    public abstract Object accept(FilterVisitor var1, Object var2);
}

