/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.SumVisitor;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class SumAreaVisitor
extends SumVisitor {
    static FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public SumAreaVisitor(Expression expr) throws IllegalFilterException {
        super((Expression)factory.function("area2", new Expression[]{expr}));
    }

    @Override
    public void visit(SimpleFeature feature) {
        this.setStrategy(new SumAreaStrategy());
        super.visit(feature);
    }

    @Override
    public void visit(Feature feature) {
        this.setStrategy(new SumAreaStrategy());
        super.visit(feature);
    }

    public SumAreaVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        this((Expression)factory.property(type.getDescriptor(attributeTypeIndex).getLocalName()));
    }

    public SumAreaVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        this((Expression)factory.property(type.getDescriptor(attrName).getLocalName()));
    }

    static class SumAreaStrategy
    implements SumVisitor.SumStrategy {
        Double number = null;

        SumAreaStrategy() {
        }

        @Override
        public void add(Object value) {
            Number num = (Number)value;
            if (num.doubleValue() >= 0.0) {
                if (this.number == null) {
                    this.number = 0.0;
                }
                this.number = this.number + num.doubleValue();
            }
        }

        @Override
        public Object getResult() {
            return this.number == null ? null : Double.valueOf(this.number);
        }
    }
}

