/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.Mosaic;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.i18n.Errors;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

final class GridCoverageRendererUtilities {
    private static final CoverageProcessor processor = CoverageProcessor.getInstance((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));

    GridCoverageRendererUtilities() {
    }

    static void ensureNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    static void ensureSourceNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(3, name));
        }
    }

    static GridCoverage2D reproject(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope, double[] bkgValues, Hints hints) throws FactoryException {
        assert (CRS.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs) || CRS.findMathTransform((CoordinateReferenceSystem)destinationEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs).isIdentity());
        ParameterValueGroup param = processor.getOperation("Resample").getParameters().clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        if (bkgValues != null) {
            param.parameter("BackgroundValues").setValue((Object)bkgValues);
        }
        return (GridCoverage2D)((Resample)processor.getOperation("Resample")).doOperation(param, hints);
    }

    static GridCoverage2D crop(GridCoverage2D gc, GeneralEnvelope envelope, double[] background, Hints hints) {
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
        intersectionEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)oldEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters().clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("Envelope").setValue((Object)intersectionEnvelope);
        return (GridCoverage2D)((Crop)processor.getOperation("CoverageCrop")).doOperation(param, hints);
    }

    static GridCoverage2D displace(GridCoverage2D coverage, double tx, double ty, GridCoverageFactory gridCoverageFactory) {
        GridGeometry2D originalGG = coverage.getGridGeometry();
        GridEnvelope gridRange = originalGG.getGridRange();
        Envelope2D envelope = originalGG.getEnvelope2D();
        double minx = envelope.getMinX() + tx;
        double miny = envelope.getMinY() + ty;
        double maxx = envelope.getMaxX() + tx;
        double maxy = envelope.getMaxY() + ty;
        ReferencedEnvelope translatedEnvelope = new ReferencedEnvelope(minx, maxx, miny, maxy, envelope.getCoordinateReferenceSystem());
        GridGeometry2D translatedGG = new GridGeometry2D(gridRange, (org.opengis.geometry.Envelope)translatedEnvelope);
        GridCoverage2D translatedCoverage = gridCoverageFactory.create((CharSequence)coverage.getName(), coverage.getRenderedImage(), translatedGG, coverage.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
        return translatedCoverage;
    }

    static GridCoverage2D mosaic(List<GridCoverage2D> coverages, List<GridCoverage2D> alphas, GeneralEnvelope renderingEnvelope, Hints hints, double[] background) {
        try {
            ReferencedEnvelope targetEnvelope = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)renderingEnvelope);
            ReferencedEnvelope coveragesEnvelope = null;
            for (GridCoverage2D coverage : coverages) {
                ReferencedEnvelope re = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)coverage.getEnvelope2D());
                if (coveragesEnvelope == null) {
                    coveragesEnvelope = re;
                    continue;
                }
                coveragesEnvelope.expandToInclude((Envelope)re);
            }
            if ((targetEnvelope = new ReferencedEnvelope((Envelope)targetEnvelope.intersection(coveragesEnvelope), renderingEnvelope.getCoordinateReferenceSystem())).isEmpty() || targetEnvelope.isNull()) {
                return null;
            }
            MathTransform2D mt = coverages.get(0).getGridGeometry().getCRSToGrid2D();
            Rectangle rasterSpaceEnvelope = CRS.transform((MathTransform)mt, (org.opengis.geometry.Envelope)targetEnvelope).toRectangle2D().getBounds();
            GridEnvelope2D gridRange = new GridEnvelope2D(rasterSpaceEnvelope);
            GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (org.opengis.geometry.Envelope)targetEnvelope);
            ParameterValueGroup param = processor.getOperation("Mosaic").getParameters().clone();
            param.parameter("sources").setValue(coverages);
            param.parameter("geometry").setValue((Object)gridGeometry);
            if (background != null) {
                param.parameter("outputNoData").setValue((Object)background);
            }
            if (!alphas.isEmpty()) {
                param.parameter("alphas").setValue(alphas);
            }
            return (GridCoverage2D)((Mosaic)processor.getOperation("Mosaic")).doOperation(param, hints);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to mosaic the input coverages", e);
        }
    }

    static GeneralEnvelope reprojectEnvelope(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem outputCRS) throws Exception {
        GeneralEnvelope outputEnvelope = null;
        CoordinateReferenceSystem inputCRS = inputEnvelope.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)inputCRS, (Object)outputCRS)) {
            outputEnvelope = CRS.transform((org.opengis.geometry.Envelope)inputEnvelope, (CoordinateReferenceSystem)outputCRS);
            outputEnvelope.setCoordinateReferenceSystem(outputCRS);
        }
        if (outputEnvelope == null) {
            outputEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)inputEnvelope);
            outputEnvelope.setCoordinateReferenceSystem(inputCRS);
        }
        return null;
    }

    static GeneralEnvelope reprojectEnvelopeWithWGS84Pivot(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem targetCRS) throws Exception {
        GridCoverageRendererUtilities.ensureNotNull(inputEnvelope, "destinationEnvelope");
        GridCoverageRendererUtilities.ensureNotNull(targetCRS, "coverageCRS");
        CoordinateReferenceSystem destinationCRS = inputEnvelope.getCoordinateReferenceSystem();
        try {
            CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation(destinationCRS, targetCRS);
            GeneralEnvelope output = CRS.transform((CoordinateOperation)operation, (org.opengis.geometry.Envelope)inputEnvelope);
            output.setCoordinateReferenceSystem(targetCRS);
            return output;
        }
        catch (TransformException te) {
            GeneralEnvelope destinationEnvelopeWGS84 = GridCoverageRendererUtilities.reprojectEnvelope(inputEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return GridCoverageRendererUtilities.reprojectEnvelope(destinationEnvelopeWGS84, targetCRS);
        }
    }

    public static double[] colorToArray(Color color) {
        if (color == null) {
            return null;
        }
        return new double[]{color.getRed(), color.getGreen(), color.getBlue()};
    }
}

