/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.CMatrixRMaj;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.data.ZMatrixRMaj;

public enum MatrixType {
    DDRM(true, true, 64),
    FDRM(true, true, 32),
    ZDRM(false, true, 64),
    CDRM(false, true, 32),
    DSCC(true, false, 64),
    FSCC(true, false, 32),
    ZSCC(false, false, 64),
    CSCC(false, false, 32),
    UNSPECIFIED(false, false, 0);

    boolean fixed;
    boolean dense;
    boolean real;
    int bits;

    private MatrixType(boolean real, boolean dense, int bits) {
        this(false, real, dense, bits);
    }

    private MatrixType(boolean fixed, boolean real, boolean dense, int bits) {
        this.real = real;
        this.fixed = fixed;
        this.dense = dense;
        this.bits = bits;
    }

    public static MatrixType lookup(Class type) {
        if (type == DMatrixRMaj.class) {
            return DDRM;
        }
        if (type == FMatrixRMaj.class) {
            return FDRM;
        }
        if (type == ZMatrixRMaj.class) {
            return ZDRM;
        }
        if (type == CMatrixRMaj.class) {
            return CDRM;
        }
        if (type == DMatrixSparseCSC.class) {
            return DSCC;
        }
        if (type == FMatrixSparseCSC.class) {
            return FSCC;
        }
        throw new IllegalArgumentException("Unknown class");
    }

    public static MatrixType lookup(boolean dense, boolean real, int bits) {
        if (dense) {
            if (real) {
                if (bits == 64) {
                    return DDRM;
                }
                return FDRM;
            }
            if (bits == 64) {
                return ZDRM;
            }
            return CDRM;
        }
        if (real) {
            if (bits == 64) {
                return DSCC;
            }
            return FSCC;
        }
        throw new IllegalArgumentException("Complex sparse not yet supported");
    }

    public boolean isReal() {
        return this.real;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isDense() {
        return this.dense;
    }

    public int getBits() {
        return this.bits;
    }

    public Matrix create(int rows, int cols) {
        switch (this) {
            case DDRM: {
                return new DMatrixRMaj(rows, cols);
            }
            case FDRM: {
                return new FMatrixRMaj(rows, cols);
            }
            case ZDRM: {
                return new ZMatrixRMaj(rows, cols);
            }
            case CDRM: {
                return new CMatrixRMaj(rows, cols);
            }
            case DSCC: {
                return new DMatrixSparseCSC(rows, cols);
            }
            case FSCC: {
                return new FMatrixSparseCSC(rows, cols);
            }
        }
        throw new RuntimeException("Unknown Matrix Type " + (Object)((Object)this));
    }
}

