/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.lu;

import org.ejml.data.ZMatrixRMaj;
import org.ejml.dense.row.decompose.lu.LUDecompositionBase_ZDRM;

public class LUDecompositionNR_ZDRM
extends LUDecompositionBase_ZDRM {
    private static final double TINY = 1.0E-40;

    public boolean decompose(ZMatrixRMaj orig) {
        this.decomposeCommonInit(orig);
        for (int i = 0; i < this.m; ++i) {
            double big = 0.0;
            double bigReal = 0.0;
            double bigImg = 0.0;
            for (int j = 0; j < this.n; ++j) {
                double real = this.dataLU[i * this.stride + j * 2];
                double img = this.dataLU[i * this.stride + j * 2 + 1];
                double temp = real * real + img * img;
                if (!(big < temp)) continue;
                big = temp;
                bigReal = real;
                bigImg = img;
            }
            if (big == 0.0) {
                bigReal = 1.0;
                bigImg = 0.0;
            }
            this.vv[i * 2] = bigReal / (big * big);
            this.vv[i * 2 + 1] = -bigImg / (big * big);
        }
        for (int k = 0; k < this.n; ++k) {
            int imax = -1;
            double big = 0.0;
            for (int i = k; i < this.m; ++i) {
                double luReal = this.dataLU[i * this.stride + k * 2];
                double vvReal = this.vv[i * 2];
                double luImg = this.dataLU[i * this.stride + k * 2 + 1];
                double vvImg = this.vv[i * 2 + 1];
                double tmpReal = luReal * vvReal - luImg * vvImg;
                double tmpImg = luImg * vvReal + luReal * vvReal;
                double tmpMag = tmpReal * tmpReal + tmpImg * tmpImg;
                if (!(tmpMag > big)) continue;
                big = tmpMag;
                imax = i;
            }
            if (imax < 0) {
                this.indx[k] = -1;
                return true;
            }
            if (k != imax) {
                int k_n;
                int imax_n = imax * this.stride;
                int end = k_n + this.n * 2;
                for (k_n = k * this.stride; k_n < end; k_n += 2) {
                    double tempReal = this.dataLU[imax_n];
                    double tempImg = this.dataLU[imax_n + 1];
                    this.dataLU[imax_n] = this.dataLU[k_n];
                    this.dataLU[imax_n + 1] = this.dataLU[k_n + 1];
                    this.dataLU[k_n] = tempReal;
                    this.dataLU[k_n + 1] = tempImg;
                    imax_n += 2;
                }
                this.pivsign = -this.pivsign;
                this.vv[imax * 2] = this.vv[k * 2];
                this.vv[imax * 2 + 1] = this.vv[k * 2 + 1];
                int z = this.pivot[imax];
                this.pivot[imax] = this.pivot[k];
                this.pivot[k] = z;
            }
            this.indx[k] = imax;
            double element_kk_real = this.dataLU[k * this.stride + k * 2];
            double element_kk_img = this.dataLU[k * this.stride + k * 2 + 1];
            double mag = element_kk_real * element_kk_real + element_kk_img * element_kk_img;
            if (mag == 0.0) {
                element_kk_real = 1.0E-40;
                this.dataLU[k * this.stride + k * 2] = 1.0E-40;
                element_kk_img = 0.0;
                this.dataLU[k * this.stride + k * 2 + 1] = 0.0;
            }
            double element_kk_norm2 = element_kk_real * element_kk_real + element_kk_img * element_kk_img;
            for (int i = k + 1; i < this.m; ++i) {
                int i_n = i * this.stride;
                double luReal = this.dataLU[i_n + k * 2];
                double luImg = this.dataLU[i_n + k * 2 + 1];
                double tmpReal = (luReal * element_kk_real + luImg * element_kk_img) / element_kk_norm2;
                double tmpImg = (luImg * element_kk_real - luReal * element_kk_img) / element_kk_norm2;
                this.dataLU[i_n + k * 2] = tmpReal;
                this.dataLU[i_n + k * 2 + 1] = tmpImg;
                int k_n = k * this.stride + k * 2 + 2;
                int end = i_n + this.n * 2;
                i_n += k * 2 + 2;
                while (i_n < end) {
                    luReal = this.dataLU[k_n];
                    luImg = this.dataLU[k_n + 1];
                    int n = i_n;
                    this.dataLU[n] = this.dataLU[n] - (tmpReal * luReal - tmpImg * luImg);
                    int n2 = i_n + 1;
                    this.dataLU[n2] = this.dataLU[n2] - (tmpReal * luImg + tmpImg * luReal);
                    k_n += 2;
                    i_n += 2;
                }
            }
        }
        return true;
    }
}

