/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.mult;

import java.util.Arrays;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.misc.TriangularSolver_DSCC;

public class ImplSparseSparseMult_DSCC {
    public static void mult(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        double[] x = TriangularSolver_DSCC.adjust(gx, A.numRows);
        int[] w = TriangularSolver_DSCC.adjust(gw, A.numRows, A.numRows);
        C.growMaxLength(A.nz_length + B.nz_length, false);
        C.indicesSorted = false;
        C.nz_length = 0;
        int idx0 = B.col_idx[0];
        for (int bj = 1; bj <= B.numCols; ++bj) {
            int colB = bj - 1;
            int idx1 = B.col_idx[bj];
            C.col_idx[bj] = C.nz_length;
            if (idx0 == idx1) continue;
            for (int bi = idx0; bi < idx1; ++bi) {
                int rowB = B.nz_rows[bi];
                double valB = B.nz_values[bi];
                ImplSparseSparseMult_DSCC.multAddColA(A, rowB, valB, C, colB + 1, x, w);
            }
            int idxC0 = C.col_idx[colB];
            int idxC1 = C.col_idx[colB + 1];
            for (int i = idxC0; i < idxC1; ++i) {
                C.nz_values[i] = x[C.nz_rows[i]];
            }
            idx0 = idx1;
        }
    }

    public static void multTransA(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        double[] x = TriangularSolver_DSCC.adjust(gx, A.numRows);
        int[] w = TriangularSolver_DSCC.adjust(gw, A.numRows, A.numRows);
        C.growMaxLength(A.nz_length + B.nz_length, false);
        C.indicesSorted = true;
        C.nz_length = 0;
        C.col_idx[0] = 0;
        int idxB0 = B.col_idx[0];
        for (int bj = 1; bj <= B.numCols; ++bj) {
            int idxB1 = B.col_idx[bj];
            C.col_idx[bj] = C.nz_length;
            if (idxB0 == idxB1) continue;
            for (int bi = idxB0; bi < idxB1; ++bi) {
                int rowB = B.nz_rows[bi];
                x[rowB] = B.nz_values[bi];
                w[rowB] = bj;
            }
            for (int colA = 0; colA < A.numCols; ++colA) {
                int idxA0 = A.col_idx[colA];
                int idxA1 = A.col_idx[colA + 1];
                double sum = 0.0;
                for (int ai = idxA0; ai < idxA1; ++ai) {
                    int rowA = A.nz_rows[ai];
                    if (w[rowA] != bj) continue;
                    sum += x[rowA] * A.nz_values[ai];
                }
                if (sum == 0.0) continue;
                if (C.nz_length == C.nz_values.length) {
                    C.growMaxLength(C.nz_length * 2 + 1, true);
                }
                C.nz_values[C.nz_length] = sum;
                C.nz_rows[C.nz_length++] = colA;
            }
            C.col_idx[bj] = C.nz_length;
            idxB0 = idxB1;
        }
    }

    public static void multTransB(DMatrixSparseCSC A, DMatrixSparseCSC B, DMatrixSparseCSC C, IGrowArray gw, DGrowArray gx) {
        if (!B.isIndicesSorted()) {
            throw new IllegalArgumentException("B must have its indices sorted.");
        }
        if (!CommonOps_DSCC.checkIndicesSorted(B)) {
            throw new IllegalArgumentException("Crap. Not really sorted");
        }
        double[] x = TriangularSolver_DSCC.adjust(gx, A.numRows);
        int[] w = TriangularSolver_DSCC.adjust(gw, A.numRows + B.numCols, A.numRows);
        C.growMaxLength(A.nz_length + B.nz_length, false);
        C.indicesSorted = false;
        C.nz_length = 0;
        C.col_idx[0] = 0;
        int locationB = A.numRows;
        System.arraycopy(B.col_idx, 0, w, locationB, B.numCols);
        for (int colC = 0; colC < B.numRows; ++colC) {
            C.col_idx[colC + 1] = C.nz_length;
            int mark = colC + 1;
            for (int colB = 0; colB < B.numCols; ++colB) {
                int row;
                int bi = w[locationB + colB];
                if (bi >= B.col_idx[colB + 1] || (row = B.nz_rows[bi]) != colC) continue;
                ImplSparseSparseMult_DSCC.multAddColA(A, colB, B.nz_values[bi], C, mark, x, w);
                int n = locationB + colB;
                w[n] = w[n] + 1;
            }
            int idxC0 = C.col_idx[colC];
            int idxC1 = C.col_idx[colC + 1];
            for (int i = idxC0; i < idxC1; ++i) {
                C.nz_values[i] = x[C.nz_rows[i]];
            }
        }
    }

    public static void multAddColA(DMatrixSparseCSC A, int colA, double alpha, DMatrixSparseCSC C, int mark, double[] x, int[] w) {
        int idxA0 = A.col_idx[colA];
        int idxA1 = A.col_idx[colA + 1];
        for (int j = idxA0; j < idxA1; ++j) {
            int row = A.nz_rows[j];
            if (w[row] < mark) {
                if (C.nz_length >= C.nz_rows.length) {
                    C.growMaxLength(C.nz_length * 2 + 1, true);
                }
                w[row] = mark;
                C.nz_rows[C.nz_length] = row;
                C.col_idx[mark] = ++C.nz_length;
                x[row] = A.nz_values[j] * alpha;
                continue;
            }
            int n = row;
            x[n] = x[n] + A.nz_values[j] * alpha;
        }
    }

    public static void addRowsInAInToC(DMatrixSparseCSC A, int colA, DMatrixSparseCSC C, int colC, int[] w) {
        int idxA0 = A.col_idx[colA];
        int idxA1 = A.col_idx[colA + 1];
        for (int j = idxA0; j < idxA1; ++j) {
            int row = A.nz_rows[j];
            if (w[row] >= colC) continue;
            if (C.nz_length >= C.nz_rows.length) {
                C.growMaxLength(C.nz_length * 2 + 1, true);
            }
            w[row] = colC;
            C.nz_rows[C.nz_length++] = row;
        }
        C.col_idx[colC + 1] = C.nz_length;
    }

    public static void mult(DMatrixSparseCSC A, DMatrixRMaj B, DMatrixRMaj C) {
        C.zero();
        for (int k = 0; k < A.numCols; ++k) {
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int indexA = idx0; indexA < idx1; ++indexA) {
                int i = A.nz_rows[indexA];
                double valueA = A.nz_values[indexA];
                int indexB = k * B.numCols;
                int indexC = i * C.numCols;
                int end = indexB + B.numCols;
                while (indexB < end) {
                    int n = indexC++;
                    C.data[n] = C.data[n] + valueA * B.data[indexB++];
                }
            }
        }
    }

    public static double dotInnerColumns(DMatrixSparseCSC A, int colA, DMatrixSparseCSC B, int colB, IGrowArray gw, DGrowArray gx) {
        if (A.numRows != B.numRows) {
            throw new IllegalArgumentException("Number of rows must match.");
        }
        int[] w = TriangularSolver_DSCC.adjust(gw, A.numRows);
        Arrays.fill(w, 0, A.numRows, -1);
        double[] x = TriangularSolver_DSCC.adjust(gx, A.numRows);
        int length = 0;
        int idx0 = A.col_idx[colA];
        int idx1 = A.col_idx[colA + 1];
        for (int i = idx0; i < idx1; ++i) {
            int row = A.nz_rows[i];
            x[length] = A.nz_values[i];
            w[row] = length++;
        }
        double dot = 0.0;
        idx0 = B.col_idx[colB];
        idx1 = B.col_idx[colB + 1];
        for (int i = idx0; i < idx1; ++i) {
            int row = B.nz_rows[i];
            if (w[row] == -1) continue;
            dot += x[w[row]] * B.nz_values[i];
        }
        return dot;
    }
}

