/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

public enum Symbol {
    PLUS,
    MINUS,
    TIMES,
    LDIVIDE,
    RDIVIDE,
    POWER,
    PERIOD,
    ELEMENT_TIMES,
    ELEMENT_DIVIDE,
    ELEMENT_POWER,
    ASSIGN,
    PAREN_LEFT,
    PAREN_RIGHT,
    BRACKET_LEFT,
    BRACKET_RIGHT,
    GREATER_THAN,
    LESS_THAN,
    GREATER_THAN_EQ,
    LESS_THAN_EQ,
    COMMA,
    TRANSPOSE,
    COLON,
    SEMICOLON;


    public static Symbol lookup(char c) {
        switch (c) {
            case '.': {
                return PERIOD;
            }
            case ',': {
                return COMMA;
            }
            case '\'': {
                return TRANSPOSE;
            }
            case '+': {
                return PLUS;
            }
            case '-': {
                return MINUS;
            }
            case '*': {
                return TIMES;
            }
            case '\\': {
                return LDIVIDE;
            }
            case '/': {
                return RDIVIDE;
            }
            case '^': {
                return POWER;
            }
            case '=': {
                return ASSIGN;
            }
            case '(': {
                return PAREN_LEFT;
            }
            case ')': {
                return PAREN_RIGHT;
            }
            case '[': {
                return BRACKET_LEFT;
            }
            case ']': {
                return BRACKET_RIGHT;
            }
            case '>': {
                return GREATER_THAN;
            }
            case '<': {
                return LESS_THAN;
            }
            case ':': {
                return COLON;
            }
            case ';': {
                return SEMICOLON;
            }
        }
        throw new RuntimeException("Unknown type " + c);
    }

    public static Symbol lookupElementWise(char c) {
        switch (c) {
            case '*': {
                return ELEMENT_TIMES;
            }
            case '/': {
                return ELEMENT_DIVIDE;
            }
            case '^': {
                return ELEMENT_POWER;
            }
        }
        throw new RuntimeException("Unknown element-wise type " + c);
    }
}

