/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.misc;

import java.util.Arrays;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;

public class TriangularSolver_DSCC {
    public static void solveL(DMatrixSparseCSC L, double[] x) {
        int N = L.numCols;
        int idx0 = L.col_idx[0];
        for (int col = 0; col < N; ++col) {
            int idx1 = L.col_idx[col + 1];
            int n = col;
            double d = x[n] / L.nz_values[idx0];
            x[n] = d;
            double x_j = d;
            for (int i = idx0 + 1; i < idx1; ++i) {
                int row;
                int n2 = row = L.nz_rows[i];
                x[n2] = x[n2] - L.nz_values[i] * x_j;
            }
            idx0 = idx1;
        }
    }

    public static void solveTranL(DMatrixSparseCSC L, double[] x) {
        int N = L.numCols;
        int j = N - 1;
        while (j >= 0) {
            int idx0 = L.col_idx[j];
            int idx1 = L.col_idx[j + 1];
            for (int p = idx0 + 1; p < idx1; ++p) {
                int n = j;
                x[n] = x[n] - L.nz_values[p] * x[L.nz_rows[p]];
            }
            int n = j--;
            x[n] = x[n] / L.nz_values[idx0];
        }
    }

    public static void solveU(DMatrixSparseCSC U, double[] x) {
        int N = U.numCols;
        int idx1 = U.col_idx[N];
        for (int col = N - 1; col >= 0; --col) {
            int idx0 = U.col_idx[col];
            int n = col;
            double d = x[n] / U.nz_values[idx1 - 1];
            x[n] = d;
            double x_j = d;
            for (int i = idx0; i < idx1 - 1; ++i) {
                int row;
                int n2 = row = U.nz_rows[i];
                x[n2] = x[n2] - U.nz_values[i] * x_j;
            }
            idx1 = idx0;
        }
    }

    public static void solve(DMatrixSparseCSC G, boolean lower, DMatrixSparseCSC B, DMatrixSparseCSC X, DGrowArray g_x, IGrowArray g_xi, IGrowArray g_w) {
        double[] x = TriangularSolver_DSCC.adjust(g_x, G.numRows);
        if (g_xi == null) {
            g_xi = new IGrowArray();
        }
        int[] xi = TriangularSolver_DSCC.adjust(g_xi, G.numRows);
        X.nz_length = 0;
        X.col_idx[0] = 0;
        X.indicesSorted = false;
        for (int colB = 0; colB < B.numCols; ++colB) {
            int top = TriangularSolver_DSCC.solve(G, lower, B, colB, x, null, g_xi, g_w);
            int nz_count = X.numRows - top;
            if (X.nz_values.length < X.nz_length + nz_count) {
                X.growMaxLength(X.nz_length * 2 + nz_count, true);
            }
            int p = top;
            while (p < X.numRows) {
                X.nz_rows[X.nz_length] = xi[p];
                X.nz_values[X.nz_length] = x[xi[p]];
                ++p;
                ++X.nz_length;
            }
            X.col_idx[colB + 1] = X.nz_length;
        }
    }

    public static int solve(DMatrixSparseCSC G, boolean lower, DMatrixSparseCSC B, int colB, double[] x, int[] pinv, IGrowArray g_xi, IGrowArray g_w) {
        int top;
        int[] xi = TriangularSolver_DSCC.adjust(g_xi, G.numCols);
        for (int p = top = TriangularSolver_DSCC.searchNzRowsInB(G, B, colB, pinv, xi, g_w); p < G.numCols; ++p) {
            x[xi[p]] = 0.0;
        }
        int idxB0 = B.col_idx[colB];
        int idxB1 = B.col_idx[colB + 1];
        for (int p = idxB0; p < idxB1; ++p) {
            x[B.nz_rows[p]] = B.nz_values[p];
        }
        for (int px = top; px < G.numRows; ++px) {
            int q;
            int p;
            int J;
            int j = xi[px];
            int n = J = pinv != null ? pinv[j] : j;
            if (J < 0) continue;
            if (lower) {
                int n2 = j;
                x[n2] = x[n2] / G.nz_values[G.col_idx[J]];
                p = G.col_idx[J] + 1;
                q = G.col_idx[J + 1];
            } else {
                int n3 = j;
                x[n3] = x[n3] / G.nz_values[G.col_idx[J + 1] - 1];
                p = G.col_idx[J];
                q = G.col_idx[J + 1] - 1;
            }
            while (p < q) {
                int n4 = G.nz_rows[p];
                x[n4] = x[n4] - G.nz_values[p] * x[j];
                ++p;
            }
        }
        return top;
    }

    public static int searchNzRowsInB(DMatrixSparseCSC G, DMatrixSparseCSC B, int colB, int[] pinv, int[] xi, IGrowArray gwork) {
        if (xi.length < B.numRows) {
            throw new IllegalArgumentException("xi must be at least this long: " + B.numRows);
        }
        int[] w = TriangularSolver_DSCC.adjust(gwork, B.numRows * 2, B.numRows);
        int idx0 = B.col_idx[colB];
        int idx1 = B.col_idx[colB + 1];
        int top = G.numRows;
        for (int i = idx0; i < idx1; ++i) {
            int rowB = B.nz_rows[i];
            if (w[rowB] != 0) continue;
            top = TriangularSolver_DSCC.searchNzRowsInB_DFS(rowB, G, top, pinv, xi, w);
        }
        return top;
    }

    private static int searchNzRowsInB_DFS(int rowB, DMatrixSparseCSC G, int top, int[] pinv, int[] xi, int[] w) {
        int N = G.numRows;
        int head = 0;
        xi[head] = rowB;
        while (head >= 0) {
            int G_col_new;
            int G_col = xi[head];
            int n = G_col_new = pinv != null ? pinv[G_col] : G_col;
            if (w[G_col] == 0) {
                w[G_col] = 1;
                w[N + head] = G_col_new < 0 ? 0 : G.col_idx[G_col_new];
            }
            boolean done = true;
            int idx0 = w[N + head];
            int idx1 = G_col_new < 0 ? 0 : G.col_idx[G_col_new + 1];
            for (int j = idx0; j < idx1; ++j) {
                int jrow = G.nz_rows[j];
                if (w[jrow] != 0) continue;
                w[N + head] = j + 1;
                xi[++head] = jrow;
                done = false;
                break;
            }
            if (!done) continue;
            --head;
            xi[--top] = G_col;
        }
        return top;
    }

    public static void eliminationTree(DMatrixSparseCSC A, boolean ata, int[] parent, IGrowArray gwork) {
        int m = A.numRows;
        int n = A.numCols;
        if (parent.length < n) {
            throw new IllegalArgumentException("parent must be of length N");
        }
        int[] work = TriangularSolver_DSCC.adjust(gwork, n + (ata ? m : 0));
        int ancestor = 0;
        int previous = n;
        if (ata) {
            for (int i = 0; i < m; ++i) {
                work[previous + i] = -1;
            }
        }
        for (int k = 0; k < n; ++k) {
            parent[k] = -1;
            work[ancestor + k] = -1;
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int p = idx0; p < idx1; ++p) {
                int i;
                int nz_row_p = A.nz_rows[p];
                int n2 = i = ata ? work[previous + nz_row_p] : nz_row_p;
                while (i != -1 && i < k) {
                    int inext = work[ancestor + i];
                    work[ancestor + i] = k;
                    if (inext == -1) {
                        parent[i] = k;
                        break;
                    }
                    i = inext;
                }
                if (!ata) continue;
                work[previous + nz_row_p] = k;
            }
        }
    }

    public static void postorder(int[] parent, int N, int[] post, IGrowArray gwork) {
        int j;
        if (parent.length < N) {
            throw new IllegalArgumentException("parent must be at least of length N");
        }
        if (post.length < N) {
            throw new IllegalArgumentException("post must be at least of length N");
        }
        int[] w = TriangularSolver_DSCC.adjust(gwork, 3 * N);
        int next = N;
        for (j = 0; j < N; ++j) {
            w[j] = -1;
        }
        for (j = N - 1; j >= 0; --j) {
            if (parent[j] == -1) continue;
            w[next + j] = w[parent[j]];
            w[parent[j]] = j;
        }
        int k = 0;
        for (int j2 = 0; j2 < N; ++j2) {
            if (parent[j2] != -1) continue;
            k = TriangularSolver_DSCC.postorder_dfs(j2, k, w, post, N);
        }
    }

    protected static int postorder_dfs(int j, int k, int[] w, int[] post, int N) {
        int next = N;
        int stack = 2 * N;
        int top = 0;
        w[stack + top] = j;
        while (top >= 0) {
            int p = w[stack + top];
            int i = w[p];
            if (i == -1) {
                --top;
                post[k++] = p;
                continue;
            }
            w[p] = w[next + i];
            w[stack + ++top] = i;
        }
        return k;
    }

    public static int searchNzRowsElim(DMatrixSparseCSC A, int k, int[] parent, int[] s, int[] w) {
        int p;
        int top = A.numCols;
        int idx0 = A.col_idx[k];
        int idx1 = A.col_idx[k + 1];
        w[k] = -w[k] - 2;
        for (p = idx0; p < idx1; ++p) {
            int i = A.nz_rows[p];
            if (i > k) continue;
            int len = 0;
            while (w[i] >= 0) {
                s[len++] = i;
                w[i] = -w[i] - 2;
                i = parent[i];
            }
            while (len > 0) {
                s[--top] = s[--len];
            }
        }
        for (p = top; p < A.numCols; ++p) {
            w[s[p]] = -w[s[p]] - 2;
        }
        w[k] = -w[k] - 2;
        return top;
    }

    public static int[] adjust(IGrowArray gwork, int desired) {
        if (gwork == null) {
            gwork = new IGrowArray();
        }
        gwork.reshape(desired);
        return gwork.data;
    }

    public static int[] adjust(IGrowArray gwork, int desired, int zeroToM) {
        int[] w = TriangularSolver_DSCC.adjust(gwork, desired);
        Arrays.fill(w, 0, zeroToM, 0);
        return w;
    }

    public static int[] adjustClear(IGrowArray gwork, int desired) {
        return TriangularSolver_DSCC.adjust(gwork, desired, desired);
    }

    public static double[] adjust(DGrowArray gwork, int desired) {
        if (gwork == null) {
            gwork = new DGrowArray();
        }
        gwork.reshape(desired);
        return gwork.data;
    }

    public static double qualityTriangular(DMatrixSparseCSC T) {
        int N = Math.min(T.numRows, T.numCols);
        double max = T.unsafe_get(0, 0);
        for (int i = 1; i < N; ++i) {
            max = Math.max(max, Math.abs(T.unsafe_get(i, i)));
        }
        if (max == 0.0) {
            return 0.0;
        }
        double quality = 1.0;
        for (int i = 0; i < N; ++i) {
            quality *= T.unsafe_get(i, i) / max;
        }
        return Math.abs(quality);
    }
}

