/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.linsol.qr;

import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.interfaces.decomposition.DecompositionInterface;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.decomposition.qr.QrHelperFunctions_DSCC;
import org.ejml.sparse.csc.decomposition.qr.QrLeftLookingDecomposition_DSCC;
import org.ejml.sparse.csc.misc.TriangularSolver_DSCC;

public class LinearSolverQrLeftLooking_DSCC
implements LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> {
    private QrLeftLookingDecomposition_DSCC qr;
    private int m;
    private int n;
    private DGrowArray gb = new DGrowArray();
    private DGrowArray gbp = new DGrowArray();
    private DGrowArray gx = new DGrowArray();

    public LinearSolverQrLeftLooking_DSCC(QrLeftLookingDecomposition_DSCC qr) {
        this.qr = qr;
    }

    public boolean setA(DMatrixSparseCSC A) {
        if (A.numCols > A.numRows) {
            throw new IllegalArgumentException("Can't handle wide matrices");
        }
        this.m = A.numRows;
        this.n = A.numCols;
        return this.qr.decompose(A) && !this.qr.isSingular();
    }

    public double quality() {
        return TriangularSolver_DSCC.qualityTriangular(this.qr.getR());
    }

    public void lockStructure() {
        this.qr.lockStructure();
    }

    public boolean isStructureLocked() {
        return this.qr.isStructureLocked();
    }

    public void solve(DMatrixRMaj B, DMatrixRMaj X) {
        double[] b = TriangularSolver_DSCC.adjust(this.gb, B.numRows);
        double[] bp = TriangularSolver_DSCC.adjust(this.gbp, B.numRows);
        double[] x = TriangularSolver_DSCC.adjust(this.gx, X.numRows);
        int[] pinv = this.qr.getStructure().getPinv();
        for (int colX = 0; colX < X.numCols; ++colX) {
            double[] out;
            int index = colX;
            int i = 0;
            while (i < B.numRows) {
                b[i] = B.data[index];
                ++i;
                index += X.numCols;
            }
            CommonOps_DSCC.permuteInv(pinv, b, bp, this.m);
            for (int j = 0; j < this.n; ++j) {
                QrHelperFunctions_DSCC.applyHouseholder(this.qr.getV(), j, this.qr.getBeta(j), bp);
            }
            TriangularSolver_DSCC.solveU(this.qr.getR(), bp);
            if (this.qr.isFillPermutated()) {
                CommonOps_DSCC.permute(this.qr.getFillPermutation(), bp, x, X.numRows);
                out = x;
            } else {
                out = bp;
            }
            index = colX;
            int i2 = 0;
            while (i2 < X.numRows) {
                X.data[index] = out[i2];
                ++i2;
                index += X.numCols;
            }
        }
    }

    public boolean modifiesA() {
        return this.qr.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public <D extends DecompositionInterface> D getDecomposition() {
        return (D)this.qr;
    }
}

