/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.decomposition.svd;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class SmartRotatorUpdate {
    DMatrixRMaj R;
    int[] mod = new int[1];

    public DMatrixRMaj getR() {
        return this.R;
    }

    public void init(DMatrixRMaj R) {
        this.R = R;
        CommonOps_DDRM.setIdentity((DMatrix1Row)R);
        int a = Math.min(R.numRows, R.numCols);
        if (this.mod.length < a) {
            this.mod = new int[a];
        }
        for (int i = 0; i < a; ++i) {
            this.mod[i] = i;
        }
    }

    public void update(int rowA, int rowB, double c, double s) {
        int l;
        this.mod[rowA] = l = Math.max(this.mod[rowA], this.mod[rowB]);
        this.mod[rowB] = l;
        int indexA = rowA * this.R.numCols;
        int indexB = rowB * this.R.numCols;
        int i = 0;
        while (i < l) {
            double a = this.R.data[indexA];
            double b = this.R.data[indexB];
            this.R.data[indexA] = c * a + s * b;
            this.R.data[indexB] = -s * a + c * b;
            ++i;
            ++indexA;
            ++indexB;
        }
    }
}

