/*
 * Decompiled with CFR 0.152.
 */
package s57;

import java.util.ArrayList;
import s57.S57map;
import s57.S57obj;

public final class S57box {
    private S57box() {
    }

    static Ext getExt(S57map map, double lat, double lon) {
        if (lat >= map.bounds.maxlat && lon < map.bounds.maxlon) {
            return Ext.N;
        }
        if (lon <= map.bounds.minlon) {
            return Ext.W;
        }
        if (lat <= map.bounds.minlat) {
            return Ext.S;
        }
        if (lon >= map.bounds.maxlon) {
            return Ext.E;
        }
        return Ext.I;
    }

    public static void bBox(S57map map) {
        if (map.features.get((Object)S57obj.Obj.COALNE) != null) {
            ArrayList<S57map.Feature> coasts = new ArrayList<S57map.Feature>();
            class Land {
                long first;
                S57map.Snode start;
                Ext sbound;
                long last;
                S57map.Snode end;
                Ext ebound;
                S57map.Feature land;

                Land(S57map.Feature l) {
                    this.land = l;
                    this.last = 0L;
                    this.first = 0L;
                    this.end = null;
                    this.start = null;
                    this.sbound = this.ebound = Ext.I;
                }
            }
            ArrayList<Land> lands = new ArrayList<Land>();
            if (map.features.get((Object)S57obj.Obj.LNDARE) == null) {
                map.features.put(S57obj.Obj.LNDARE, new ArrayList());
            }
            for (S57map.Feature feature : (ArrayList)map.features.get((Object)S57obj.Obj.COALNE)) {
                S57map.Feature land = new S57map.Feature();
                land.id = ++map.xref;
                land.type = S57obj.Obj.LNDARE;
                land.reln = S57map.Rflag.MASTER;
                land.objs.put(S57obj.Obj.LNDARE, new S57map.ObjTab());
                ((S57map.ObjTab)land.objs.get((Object)S57obj.Obj.LNDARE)).put(0, new S57map.AttMap());
                if (feature.geom.prim == S57map.Pflag.AREA) {
                    land.geom = feature.geom;
                    ((ArrayList)map.features.get((Object)S57obj.Obj.LNDARE)).add(land);
                    continue;
                }
                if (feature.geom.prim != S57map.Pflag.LINE) continue;
                land.geom.prim = S57map.Pflag.LINE;
                land.geom.elems.addAll(feature.geom.elems);
                coasts.add(land);
            }
            while (coasts.size() > 0) {
                S57map.Feature land = (S57map.Feature)coasts.remove(0);
                S57map.Edge fedge = (S57map.Edge)map.edges.get(land.geom.elems.get((int)0).id);
                long first = fedge.first;
                long last = ((S57map.Edge)map.edges.get((Object)Long.valueOf((long)land.geom.elems.get((int)(land.geom.elems.size() - 1)).id))).last;
                if (coasts.size() > 0) {
                    boolean added = true;
                    while (added) {
                        added = false;
                        for (int i = 0; i < coasts.size(); ++i) {
                            S57map.Feature coast = (S57map.Feature)coasts.get(i);
                            S57map.Edge edge = (S57map.Edge)map.edges.get(coast.geom.elems.get((int)0).id);
                            if (edge.first == last) {
                                land.geom.elems.add(coast.geom.elems.get(0));
                                last = edge.last;
                                coasts.remove(i--);
                                added = true;
                                continue;
                            }
                            if (edge.last != first) continue;
                            land.geom.elems.add(0, coast.geom.elems.get(0));
                            first = edge.first;
                            coasts.remove(i--);
                            added = true;
                        }
                    }
                }
                lands.add(new Land(land));
            }
            ArrayList<Land> islands = new ArrayList<Land>();
            for (Land land : lands) {
                map.sortGeom(land.land);
                if (land.land.geom.prim != S57map.Pflag.AREA) continue;
                islands.add(land);
                ((ArrayList)map.features.get((Object)S57obj.Obj.LNDARE)).add(land.land);
            }
            for (Land island : islands) {
                lands.remove(island);
            }
            for (Land land : lands) {
                land.first = ((S57map.Edge)map.edges.get((Object)Long.valueOf((long)land.land.geom.elems.get((int)0).id))).first;
                land.start = (S57map.Snode)map.nodes.get(land.first);
                land.sbound = S57box.getExt(map, land.start.lat, land.start.lon);
                land.last = ((S57map.Edge)map.edges.get((Object)Long.valueOf((long)land.land.geom.elems.get((int)(land.land.geom.comps.get((int)0).size - 1)).id))).last;
                land.end = (S57map.Snode)map.nodes.get(land.last);
                land.ebound = S57box.getExt(map, land.end.lat, land.end.lon);
            }
            islands = new ArrayList();
            for (Land land : lands) {
                if (land.sbound != Ext.I && land.ebound != Ext.I) continue;
                islands.add(land);
            }
            for (Land island : islands) {
                lands.remove(island);
            }
            for (Land land : lands) {
                S57map.Edge nedge = new S57map.Edge();
                nedge.first = land.last;
                nedge.last = land.first;
                Ext bound = land.ebound;
                block16: while (bound != land.sbound) {
                    switch (bound) {
                        case N: {
                            nedge.nodes.add(1L);
                            bound = Ext.W;
                            continue block16;
                        }
                        case W: {
                            nedge.nodes.add(2L);
                            bound = Ext.S;
                            continue block16;
                        }
                        case S: {
                            nedge.nodes.add(3L);
                            bound = Ext.E;
                            continue block16;
                        }
                        case E: {
                            nedge.nodes.add(4L);
                            bound = Ext.N;
                            continue block16;
                        }
                    }
                }
                map.edges.put(++map.xref, nedge);
                land.land.geom.elems.add(new S57map.Prim(map.xref));
                ++land.land.geom.comps.get((int)0).size;
                land.land.geom.prim = S57map.Pflag.AREA;
                ((ArrayList)map.features.get((Object)S57obj.Obj.LNDARE)).add(land.land);
            }
        }
    }

    static enum Ext {
        I,
        N,
        W,
        S,
        E;

    }
}

