/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.helper;

import java.awt.geom.Point2D;

public class GeoLine {
    private double lat1;
    private double lon1;
    private double lat2;
    private double lon2;
    private double distance;
    private double R = 6371000.0;

    public GeoLine(Point2D startPoint, Point2D endPoint) {
        this.lat1 = startPoint.getY();
        this.lon1 = startPoint.getX();
        this.lat2 = endPoint.getY();
        this.lon2 = endPoint.getX();
        this.distance = this.getDistance();
    }

    public GeoLine(double startLat, double startLon, double endLat, double endLon) {
        this.lat1 = startLat;
        this.lon1 = startLon;
        this.lat2 = endLat;
        this.lon2 = endLon;
        this.distance = this.getDistance();
    }

    public Point2D pointOnLine(double distanceFromStart) {
        double newLat = this.lat1 + (this.lat2 - this.lat1) * (distanceFromStart / this.distance);
        double newLon = this.lon1 + (this.lon2 - this.lon1) * (distanceFromStart / this.distance);
        return new Point2D.Double(newLon, newLat);
    }

    public double getDistance() {
        double phi1 = this.degToRad(this.lat1);
        double phi2 = this.degToRad(this.lat2);
        double deltaPhi = this.degToRad(this.lat2 - this.lat1);
        double deltaLambda = this.degToRad(this.lon2 - this.lon1);
        double a = Math.sin(deltaPhi / 2.0) * Math.sin(deltaPhi / 2.0) + Math.cos(phi1) * Math.cos(phi2) * Math.sin(deltaLambda / 2.0) * Math.sin(deltaLambda / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return this.R * c;
    }

    private double degToRad(double x) {
        return x * Math.PI / 180.0;
    }
}

