/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ConnectedWaysAction
extends JosmAction {
    public ConnectedWaysAction() {
        super(I18n.tr((String)"All connected ways", (Object[])new Object[0]), "adjwaysall", I18n.tr((String)"Select all connected ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:adjwaysall", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"All connected ways"}), (int)69, (int)5009), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectConnectedWays"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selectedNodes = ds.getSelectedNodes();
        Collection selectedWays = ds.getSelectedWays();
        HashSet<Way> newWays = new HashSet<Way>();
        if (!selectedNodes.isEmpty()) {
            NodeWayUtils.addWaysConnectedToNodes(selectedNodes, newWays);
        }
        newWays.addAll(selectedWays);
        NodeWayUtils.addWaysConnectedToWaysRecursively(selectedWays, newWays);
        ds.setSelected(newWays);
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

