/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import reverter.MultiOsmReader;
import reverter.ParseCallback;

public class OsmServerMultiObjectReader
extends OsmServerReader {
    private final MultiOsmReader rdr = new MultiOsmReader();
    protected static final int maxQueryIds = 128;

    public void readObject(PrimitiveId id, int version, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.readObject(id.getUniqueId(), version, id.getType(), progressMonitor);
    }

    public void readObject(long id, int version, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getAPIName());
        sb.append("/");
        sb.append(id);
        sb.append("/");
        sb.append(version);
        progressMonitor.beginTask("", 1);
        try (InputStream in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));){
            this.rdr.addData(in);
        }
        catch (IOException | IllegalDataException e) {
            throw new OsmTransferException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private List<String> makeQueryStrings(OsmPrimitiveType type, Map<Long, Integer> list) {
        ArrayList<String> result = new ArrayList<String>((list.size() + 128 - 1) / 128);
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        for (Map.Entry<Long, Integer> entry : list.entrySet()) {
            if (cnt == 0) {
                sb.append(type.getAPIName());
                sb.append("s?");
                sb.append(type.getAPIName());
                sb.append("s=");
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey());
            sb.append("v");
            sb.append(entry.getValue());
            if (++cnt < 128) continue;
            result.add(sb.toString());
            sb.setLength(0);
            cnt = 0;
        }
        if (cnt > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMultiObjects(final OsmPrimitiveType type, final Map<Long, Integer> list, final ProgressMonitor progressMonitor) {
        for (String query : this.makeQueryStrings(type, list)) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.rdr.callback = new ParseCallback(){

                @Override
                public void primitiveParsed(PrimitiveId id) {
                    if (id.getType() == type && list.remove(id.getUniqueId()) != null) {
                        progressMonitor.worked(1);
                    }
                }
            };
            try {
                InputStream in = this.getInputStream(query, NullProgressMonitor.INSTANCE);
                try {
                    this.rdr.addData(in);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException | IllegalDataException | OsmTransferException e) {
                Logging.warn((Throwable)e);
            }
            finally {
                this.rdr.callback = null;
            }
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        progressMonitor.subTask(I18n.tr((String)"Preparing history data...", (Object[])new Object[0]));
        try {
            this.rdr.processData();
            DataSet dataSet = this.rdr.getDataSet();
            return dataSet;
        }
        catch (Exception e) {
            throw new OsmTransferException((Throwable)e);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

