/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.XmlUtils;
import reverter.ParseCallback;

public class MultiOsmReader
extends OsmReader {
    public ParseCallback callback;

    public void addData(InputStream source) throws IllegalDataException {
        try (UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)source);){
            this.setParser(XmlUtils.newSafeXMLInputFactory().createXMLStreamReader((Reader)ir));
            this.parse();
        }
        catch (Exception e) {
            throw new IllegalDataException((Throwable)e);
        }
    }

    public void processData() throws IllegalDataException {
        this.prepareDataSet();
    }

    protected Node parseNode() throws XMLStreamException {
        Node node = super.parseNode();
        if (this.callback != null) {
            this.callback.primitiveParsed(node.getPrimitiveId());
        }
        return node;
    }

    protected Way parseWay() throws XMLStreamException {
        Way way = super.parseWay();
        if (this.callback != null) {
            this.callback.primitiveParsed(way.getPrimitiveId());
        }
        return way;
    }

    protected Relation parseRelation() throws XMLStreamException {
        Relation relation = super.parseRelation();
        if (this.callback != null) {
            this.callback.primitiveParsed(relation.getPrimitiveId());
        }
        return relation;
    }
}

