/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.customizepublictransportstop;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.customizepublictransportstop.CustomizeStopAction;
import org.openstreetmap.josm.plugins.customizepublictransportstop.MessageBox;
import org.openstreetmap.josm.plugins.customizepublictransportstop.StopArea;
import org.openstreetmap.josm.tools.I18n;

public class CustomizePublicTransportStopDialog
implements ActionListener,
ItemListener,
KeyListener {
    private static final String CANCEL_COMMAND = "cancel";
    private static final String SAVE_COMMAND = "save";
    private static final String PUBLIC_TRANSPORT_LANG_SECTION_NAME = "PublicTransport";
    private static final String CANCEL_BUTTON_CAPTION = "Cancel";
    private static final String SAVE_BUTTON_CAPTION = "Save";
    private static final String AREA_CAPTION = "Area";
    private static final String COVER_CAPTION = "Cover";
    private static final String SHELTER_CAPTION = "Shelter";
    private static final String BENCH_CAPTION = "Bench";
    private static final String RAILWAY_STOP_CAPTION = "Railway stop";
    private static final String RAILWAY_STATION_CAPTION = "Railway station";
    private static final String TRAM_CAPTION = "Tram";
    private static final String TROLLEYBUS_CAPTION = "Trolleybus";
    private static final String SHARE_TAXI_CAPTION = "Share taxi";
    private static final String BUS_CAPTION = "Bus";
    private static final String BUS_STATION_CAPTION = "Bus station";
    private static final String ASSIGN_TRANSPORT_TYPE_CAPTION = "Assign transport type to platform";
    private static final String NETWORK_LEVEL_CAPTION = "Network level";
    private static final String OPERATOR_CAPTION = "Operator";
    private static final String NETWORK_CAPTION = "Network";
    private static final String NAME_EN_CAPTION = "Name (en.)";
    private static final String NAME_CAPTION = "Name";
    private static final String STOP_CUSTOMIZING_DIALOG_CAPTION = "Stop customizing";
    public static final String LONG_DISTANCE_NETWORK_CAPTION = "Long distance";
    public static final String REGIONAL_NETWORK_CAPTION = "Regional";
    public static final String COMMUTER_NETWORK_CAPTION = "Commuter";
    public static final String CITY_NETWORK_CAPTION = "City transport";
    public static final String HIGH_SPEED_NETWORK_CAPTION = "High speed";
    private String[] serviceCaptionStrings = new String[]{"City transport", "Commuter", "Regional", "Long distance", "High speed"};
    private String[] serviceStrings = new String[]{"urban", "commuter", "regional", "long_distance", "high_speed"};
    private JDialog jDialog = null;
    private JTextField textFieldName = null;
    private JTextField textFieldNameEn;
    private JTextField textFieldNetwork;
    private JTextField textFieldOperator;
    private JComboBox<String> comboBoxService;
    private JCheckBox checkBoxIsBus;
    private JCheckBox checkBoxIsTrolleybus;
    private JCheckBox checkBoxIsShareTaxi;
    private JCheckBox checkBoxIsBusStation;
    private JCheckBox checkBoxIsAssignTransportType;
    private JCheckBox checkBoxIsTram;
    private JCheckBox checkBoxIsTrainStation;
    private JCheckBox checkBoxIsTrainStop;
    private JCheckBox checkBoxIsBench;
    private JCheckBox checkBoxIsShelter;
    private JCheckBox checkBoxIsCover;
    private JCheckBox checkBoxIsArea;
    private StopArea stopArea;
    private CustomizeStopAction customizeStopAction;
    private HashMap<JCheckBox, Boolean> checkBoxValues = new HashMap();
    private static String previousName;
    private static String previousNameEn;
    private static String previousNetwork;
    private static String previousOperator;
    private static CustomizePublicTransportStopDialog customizePublicTransportStopDialogInstance;

    public static CustomizePublicTransportStopDialog showCustomizePublicTransportStopDialog(CustomizeStopAction customizeStopAction, StopArea stopArea) {
        if (customizePublicTransportStopDialogInstance == null) {
            customizePublicTransportStopDialogInstance = new CustomizePublicTransportStopDialog(customizeStopAction, stopArea);
        } else {
            customizePublicTransportStopDialogInstance.setCustomizeStopAction(customizeStopAction);
            customizePublicTransportStopDialogInstance.setStopArea(stopArea);
        }
        customizePublicTransportStopDialogInstance.setVisible(true);
        return customizePublicTransportStopDialogInstance;
    }

    public CustomizePublicTransportStopDialog() {
        Frame frame = JOptionPane.getFrameForComponent((Component)MainApplication.getMainFrame());
        this.jDialog = new JDialog(frame, I18n.tr((String)STOP_CUSTOMIZING_DIALOG_CAPTION, (Object[])new Object[0]), false);
        JPanel contentPane = this.createContentPane();
        this.jDialog.add(contentPane);
        this.jDialog.pack();
        this.jDialog.setLocationRelativeTo(frame);
        this.jDialog.addKeyListener(this);
        contentPane.addKeyListener(this);
    }

    private JPanel createContentPane() {
        JPanel contentPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        GridBagConstraints layoutCons = new GridBagConstraints();
        JLabel label = new JLabel(I18n.tr((String)NAME_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 0;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(label, layoutCons);
        label.addKeyListener(this);
        contentPane.add(label);
        this.textFieldName = new JTextField("", 25);
        layoutCons.gridx = 1;
        layoutCons.gridy = 0;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.textFieldName, layoutCons);
        this.textFieldName.addKeyListener(this);
        contentPane.add(this.textFieldName);
        JLabel labelNameEn = new JLabel(I18n.tr((String)NAME_EN_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 1;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(labelNameEn, layoutCons);
        labelNameEn.addKeyListener(this);
        contentPane.add(labelNameEn);
        this.textFieldNameEn = new JTextField("", 25);
        layoutCons.gridx = 1;
        layoutCons.gridy = 1;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.textFieldNameEn, layoutCons);
        this.textFieldNameEn.addKeyListener(this);
        contentPane.add(this.textFieldNameEn);
        JLabel labelNetwork = new JLabel(I18n.tr((String)NETWORK_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 2;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(labelNetwork, layoutCons);
        labelNetwork.addKeyListener(this);
        contentPane.add(labelNetwork);
        this.textFieldNetwork = new JTextField("", 25);
        layoutCons.gridx = 1;
        layoutCons.gridy = 2;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.textFieldNetwork, layoutCons);
        this.textFieldNetwork.addKeyListener(this);
        contentPane.add(this.textFieldNetwork);
        JLabel labelOperator = new JLabel(I18n.tr((String)OPERATOR_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 3;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(labelOperator, layoutCons);
        labelOperator.addKeyListener(this);
        contentPane.add(labelOperator);
        this.textFieldOperator = new JTextField("", 25);
        layoutCons.gridx = 1;
        layoutCons.gridy = 3;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.textFieldOperator, layoutCons);
        this.textFieldOperator.addKeyListener(this);
        contentPane.add(this.textFieldOperator);
        JLabel labelService = new JLabel(I18n.tr((String)NETWORK_LEVEL_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 4;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(labelService, layoutCons);
        labelService.addKeyListener(this);
        contentPane.add(labelService);
        String[] serviceTransStrings = new String[this.serviceCaptionStrings.length];
        for (int i = 0; i < this.serviceCaptionStrings.length; ++i) {
            serviceTransStrings[i] = I18n.tr((String)this.serviceCaptionStrings[i], (Object[])new Object[0]);
        }
        this.comboBoxService = new JComboBox<String>(serviceTransStrings);
        this.comboBoxService.setSelectedIndex(0);
        layoutCons.gridx = 1;
        layoutCons.gridy = 4;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.comboBoxService, layoutCons);
        this.comboBoxService.addKeyListener(this);
        contentPane.add(this.comboBoxService);
        this.checkBoxIsBus = new JCheckBox(I18n.tr((String)BUS_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 5;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsBus, layoutCons);
        this.checkBoxIsBus.addItemListener(this);
        this.checkBoxIsBus.addKeyListener(this);
        contentPane.add(this.checkBoxIsBus);
        this.checkBoxIsShareTaxi = new JCheckBox(I18n.tr((String)SHARE_TAXI_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 5;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsShareTaxi, layoutCons);
        this.checkBoxIsShareTaxi.addItemListener(this);
        this.checkBoxIsShareTaxi.addKeyListener(this);
        contentPane.add(this.checkBoxIsShareTaxi);
        this.checkBoxIsTrolleybus = new JCheckBox(I18n.tr((String)TROLLEYBUS_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 6;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsTrolleybus, layoutCons);
        this.checkBoxIsTrolleybus.addItemListener(this);
        this.checkBoxIsTrolleybus.addKeyListener(this);
        contentPane.add(this.checkBoxIsTrolleybus);
        this.checkBoxIsBusStation = new JCheckBox(I18n.tr((String)BUS_STATION_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 6;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsBusStation, layoutCons);
        this.checkBoxIsBusStation.addItemListener(this);
        this.checkBoxIsBusStation.addKeyListener(this);
        contentPane.add(this.checkBoxIsBusStation);
        this.checkBoxIsTram = new JCheckBox(I18n.tr((String)TRAM_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 7;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsTram, layoutCons);
        this.checkBoxIsTram.addItemListener(this);
        this.checkBoxIsTram.addKeyListener(this);
        contentPane.add(this.checkBoxIsTram);
        this.checkBoxIsTrainStation = new JCheckBox(I18n.tr((String)RAILWAY_STATION_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 8;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsTrainStation, layoutCons);
        this.checkBoxIsTrainStation.addItemListener(this);
        this.checkBoxIsTrainStation.addKeyListener(this);
        contentPane.add(this.checkBoxIsTrainStation);
        this.checkBoxIsTrainStop = new JCheckBox(I18n.tr((String)RAILWAY_STOP_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 8;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsTrainStop, layoutCons);
        this.checkBoxIsTrainStop.addItemListener(this);
        this.checkBoxIsTrainStop.addKeyListener(this);
        contentPane.add(this.checkBoxIsTrainStop);
        this.checkBoxIsAssignTransportType = new JCheckBox(I18n.tr((String)ASSIGN_TRANSPORT_TYPE_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 9;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsAssignTransportType, layoutCons);
        this.checkBoxIsAssignTransportType.addItemListener(this);
        this.checkBoxIsAssignTransportType.addKeyListener(this);
        contentPane.add(this.checkBoxIsAssignTransportType);
        this.checkBoxIsBench = new JCheckBox(I18n.tr((String)BENCH_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 10;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsBench, layoutCons);
        this.checkBoxIsBench.addItemListener(this);
        this.checkBoxIsBench.addKeyListener(this);
        contentPane.add(this.checkBoxIsBench);
        this.checkBoxIsShelter = new JCheckBox(I18n.trc((String)PUBLIC_TRANSPORT_LANG_SECTION_NAME, (String)SHELTER_CAPTION));
        layoutCons.gridx = 1;
        layoutCons.gridy = 10;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsShelter, layoutCons);
        this.checkBoxIsShelter.addItemListener(this);
        this.checkBoxIsShelter.addKeyListener(this);
        contentPane.add(this.checkBoxIsShelter);
        this.checkBoxIsCover = new JCheckBox(I18n.tr((String)COVER_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 11;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsCover, layoutCons);
        this.checkBoxIsCover.addItemListener(this);
        this.checkBoxIsCover.addKeyListener(this);
        contentPane.add(this.checkBoxIsCover);
        this.checkBoxIsArea = new JCheckBox(I18n.tr((String)AREA_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 11;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        gridbag.setConstraints(this.checkBoxIsArea, layoutCons);
        this.checkBoxIsArea.addItemListener(this);
        this.checkBoxIsArea.addKeyListener(this);
        contentPane.add(this.checkBoxIsArea);
        JButton buttonSave = new JButton(I18n.tr((String)SAVE_BUTTON_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 0;
        layoutCons.gridy = 12;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 2;
        layoutCons.insets = new Insets(10, 0, 0, 0);
        gridbag.setConstraints(buttonSave, layoutCons);
        buttonSave.setActionCommand(SAVE_COMMAND);
        buttonSave.addActionListener(this);
        buttonSave.addKeyListener(this);
        contentPane.add(buttonSave);
        JButton buttonCancel = new JButton(I18n.tr((String)CANCEL_BUTTON_CAPTION, (Object[])new Object[0]));
        layoutCons.gridx = 1;
        layoutCons.gridy = 12;
        layoutCons.weightx = 0.5;
        layoutCons.fill = 21;
        layoutCons.insets = new Insets(10, 0, 0, 0);
        gridbag.setConstraints(buttonCancel, layoutCons);
        buttonCancel.setActionCommand(CANCEL_COMMAND);
        buttonCancel.addActionListener(this);
        buttonCancel.addKeyListener(this);
        contentPane.add(buttonCancel);
        return contentPane;
    }

    public CustomizePublicTransportStopDialog(CustomizeStopAction customizeStopAction, StopArea stopArea) {
        this();
        this.setValues(stopArea);
        this.customizeStopAction = customizeStopAction;
        this.stopArea = stopArea;
    }

    public StopArea getStopArea() {
        return this.stopArea;
    }

    public void setStopArea(StopArea newStopArea) {
        this.setValues(newStopArea);
        this.stopArea = newStopArea;
    }

    public CustomizeStopAction getCustomizeStopAction() {
        return this.customizeStopAction;
    }

    public void setCustomizeStopAction(CustomizeStopAction newCustomizeStopAction) {
        this.customizeStopAction = newCustomizeStopAction;
    }

    public void setCheckBoxValue(JCheckBox checkBox, Boolean value) {
        this.checkBoxValues.put(checkBox, value);
        checkBox.setSelected(value);
    }

    public Boolean getCheckBoxValue(JCheckBox checkBox) {
        try {
            if (this.checkBoxValues.containsKey(checkBox)) {
                return this.checkBoxValues.get(checkBox);
            }
            return false;
        }
        catch (Exception ex) {
            MessageBox.ok(ex.getMessage());
            return false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        JCheckBox checkBox = (JCheckBox)event.getSource();
        if (event.getStateChange() == 2) {
            this.checkBoxValues.put(checkBox, false);
        } else if (event.getStateChange() == 1) {
            this.checkBoxValues.put(checkBox, true);
        }
    }

    public void setVisible(Boolean isVisible) {
        if (this.jDialog != null) {
            this.jDialog.setVisible(isVisible);
        }
    }

    private int getServiceIndex(String service) {
        for (int i = 0; i < this.serviceStrings.length; ++i) {
            if (!this.serviceStrings[i].equals(service)) continue;
            return i;
        }
        return 0;
    }

    public void setValues(StopArea stopArea) {
        if (stopArea == null) {
            return;
        }
        if (stopArea.name != null) {
            this.textFieldName.setText(stopArea.name);
        } else if (previousName != null) {
            this.textFieldName.setText(previousName);
        }
        if (stopArea.nameEn != null) {
            this.textFieldNameEn.setText(stopArea.nameEn);
        } else if (previousNameEn != null) {
            this.textFieldNameEn.setText(previousNameEn);
        }
        if (stopArea.network != null) {
            this.textFieldNetwork.setText(stopArea.network);
        } else if (previousNetwork != null) {
            this.textFieldNetwork.setText(previousNetwork);
        }
        if (stopArea.operator != null) {
            this.textFieldOperator.setText(stopArea.operator);
        } else if (previousOperator != null) {
            this.textFieldOperator.setText(previousOperator);
        }
        this.comboBoxService.setSelectedIndex(this.getServiceIndex(stopArea.service));
        this.setCheckBoxValue(this.checkBoxIsBus, stopArea.isBus);
        this.setCheckBoxValue(this.checkBoxIsShareTaxi, stopArea.isShareTaxi);
        this.setCheckBoxValue(this.checkBoxIsTrolleybus, stopArea.isTrolleybus);
        this.setCheckBoxValue(this.checkBoxIsBusStation, stopArea.isBusStation);
        this.setCheckBoxValue(this.checkBoxIsAssignTransportType, stopArea.isAssignTransportType);
        this.setCheckBoxValue(this.checkBoxIsTram, stopArea.isTram);
        this.setCheckBoxValue(this.checkBoxIsTrainStation, stopArea.isTrainStation);
        this.setCheckBoxValue(this.checkBoxIsTrainStop, stopArea.isTrainStation);
        this.setCheckBoxValue(this.checkBoxIsTrainStop, stopArea.isTrainStop);
        this.setCheckBoxValue(this.checkBoxIsBench, stopArea.isBench);
        this.setCheckBoxValue(this.checkBoxIsShelter, stopArea.isShelter);
        this.setCheckBoxValue(this.checkBoxIsCover, stopArea.isCovered);
        this.setCheckBoxValue(this.checkBoxIsArea, stopArea.isArea);
    }

    public String getTextFromControl(JTextField textField) {
        if (textField.getText().isEmpty()) {
            return null;
        }
        return textField.getText();
    }

    public StopArea saveValues() {
        StopArea stopArea = this.stopArea;
        try {
            if (stopArea == null) {
                stopArea = new StopArea();
            }
            previousName = stopArea.name = this.getTextFromControl(this.textFieldName);
            previousNameEn = stopArea.nameEn = this.getTextFromControl(this.textFieldNameEn);
            previousNetwork = stopArea.network = this.getTextFromControl(this.textFieldNetwork);
            previousOperator = stopArea.operator = this.getTextFromControl(this.textFieldOperator);
            stopArea.service = this.serviceStrings[this.comboBoxService.getSelectedIndex()];
            stopArea.isBus = this.getCheckBoxValue(this.checkBoxIsBus);
            stopArea.isShareTaxi = this.getCheckBoxValue(this.checkBoxIsShareTaxi);
            stopArea.isTrolleybus = this.getCheckBoxValue(this.checkBoxIsTrolleybus);
            stopArea.isBusStation = this.getCheckBoxValue(this.checkBoxIsBusStation);
            stopArea.isAssignTransportType = this.getCheckBoxValue(this.checkBoxIsAssignTransportType);
            stopArea.isTram = this.getCheckBoxValue(this.checkBoxIsTram);
            stopArea.isTrainStation = this.getCheckBoxValue(this.checkBoxIsTrainStation);
            stopArea.isTrainStop = this.getCheckBoxValue(this.checkBoxIsTrainStop);
            stopArea.isBench = this.getCheckBoxValue(this.checkBoxIsBench);
            stopArea.isShelter = this.getCheckBoxValue(this.checkBoxIsShelter);
            stopArea.isCovered = this.getCheckBoxValue(this.checkBoxIsCover);
            stopArea.isArea = this.getCheckBoxValue(this.checkBoxIsArea);
        }
        catch (Exception ex) {
            MessageBox.ok(ex.getMessage());
        }
        return stopArea;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (SAVE_COMMAND.equals(event.getActionCommand())) {
            this.setVisible(false);
            if (this.customizeStopAction != null) {
                StopArea stopArea = this.saveValues();
                this.customizeStopAction.performCustomizing(stopArea);
            }
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        previousNetwork = null;
        previousOperator = null;
    }
}

