/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imageryxmlbounds.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryProvidersPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsConstants;
import org.openstreetmap.josm.plugins.imageryxmlbounds.XmlBoundsLayer;
import org.openstreetmap.josm.plugins.imageryxmlbounds.data.XmlBoundsConverter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditEntriesAction
extends JosmAction
implements XmlBoundsConstants,
ListSelectionListener {
    protected static final String ACTION_NAME = I18n.tr((String)"Edit", (Object[])new Object[0]);
    private final JTable defaultTable;
    private final ImageryProvidersPanel.ImageryDefaultLayerTableModel defaultModel;
    private final List<ImageryInfo> entries;

    public EditEntriesAction(JTable defaultTable, ImageryProvidersPanel.ImageryDefaultLayerTableModel defaultModel) {
        this.putValue("ShortDescription", I18n.tr((String)"edit bounds for selected defaults", (Object[])new Object[0]));
        this.putValue("Name", ACTION_NAME);
        new ImageProvider("xml_24.png").getResource().attachImageIcon((AbstractAction)((Object)this), true);
        this.defaultModel = defaultModel;
        this.defaultTable = defaultTable;
        this.defaultTable.getSelectionModel().addListSelectionListener(this);
        this.entries = new ArrayList<ImageryInfo>();
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        XmlBoundsLayer layer = new XmlBoundsLayer(XmlBoundsConverter.convertImageryEntries(this.entries));
        GuiHelper.runInEDT(() -> {
            MainApplication.getLayerManager().addLayer((Layer)layer);
            layer.onPostLoadFromFile();
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.entries.clear();
            for (int row : this.defaultTable.getSelectedRows()) {
                ImageryInfo info = this.defaultModel.getRow(row);
                if (info == null || info.getBounds() == null) continue;
                this.entries.add(info);
            }
            this.setEnabled(!this.entries.isEmpty());
        }
    }
}

